/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.returns;

import tech.nmfin.returns.ReturnsCalculator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public enum ReturnsCalculators implements ReturnsCalculator
{
    ABSOLUTE{

        @Override
        public double computePrice(double px0, double r) {
            return px0 + r;
        }
        {
            1 a2;
        }

        @Override
        public double computeReturn(double v1, double v2) {
            return v2 - v1;
        }
    }
    ,
    SIMPLE{
        {
            2 a2;
        }

        @Override
        public double computeReturn(double v1, double v2) {
            return (v2 - v1) / v1;
        }

        @Override
        public double computePrice(double px0, double r) {
            return px0 * (r + 1.0);
        }
    }
    ,
    LOG{

        @Override
        public double computePrice(double px0, double r) {
            return px0 * Math.exp(r);
        }

        @Override
        public double computeReturn(double v1, double v2) {
            return Math.log(v2 / v1);
        }
        {
            3 a2;
        }
    };


    @Override
    public abstract double computeReturn(double var1, double var3);

    private ReturnsCalculators() {
        ReturnsCalculators a2;
    }

    @Override
    public abstract double computePrice(double var1, double var3);
}

