/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.clm;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.OuterProduct;
import dev.nm.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import java.util.List;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class MarkowitzCriticalLineUtils {
    public static Matrix getAddedInvTruncMat(Matrix oldInv, int[] oldAssetList, int newAsset, Matrix covariance) {
        Vector a2 = covariance.getRow(newAsset);
        Vector a3 = VectorFactory.subVector(a2, oldAssetList);
        double a4 = a2.get(newAsset);
        return MarkowitzCriticalLineUtils.expandInverseByOneRowColumn(oldInv, a3, a4);
    }

    public static Matrix getAddedInvTruncMat(Matrix oldInv, List<Integer> oldAssetList, int newAsset, Matrix covariance) {
        Vector a2 = covariance.getRow(newAsset);
        Vector a3 = VectorFactory.subVector(a2, oldAssetList);
        double a4 = a2.get(newAsset);
        return MarkowitzCriticalLineUtils.expandInverseByOneRowColumn(oldInv, a3, a4);
    }

    public static Matrix getDeletedInvTruncMat(Matrix oldInv, List<Integer> oldAssetList, int removedAsset) {
        int a2 = oldAssetList.indexOf(removedAsset);
        return MarkowitzCriticalLineUtils.reduceInverseByOneRowColumn(oldInv, a2 + 1);
    }

    public static double getProportion(double num, double lower, double upper) {
        return (upper - num) / (upper - lower);
    }

    public static Matrix expandInverseByOneRowColumn(Matrix invA, Vector a2, double alpha) {
        int a3 = invA.nRows();
        Vector a4 = invA.multiply(a2);
        DenseVector a5 = new DenseVector(a3 + 1);
        for (int a6 = 1; a6 <= a3; ++a6) {
            a5.set(a6, -a4.get(a6));
        }
        a5.set(a3 + 1, 1.0);
        double a7 = 1.0 / (alpha - a4.innerProduct(a2));
        OuterProduct a8 = new OuterProduct(a5.scaled(a7), a5);
        MatrixFactory.replaceInPlace(a8, 1, a3, 1, a3, invA.add(new SubMatrixRef(a8, 1, a3, 1, a3)));
        return a8;
    }

    public static Matrix reduceInverseByOneRowColumn(Matrix invA, int removedIndex) {
        int[] a2 = IntStream.rangeClosed(1, invA.nRows()).filter(a3 -> a3 != removedIndex).toArray();
        SubMatrixRef a4 = new SubMatrixRef(invA, a2, a2);
        Vector a5 = invA.getColumn(removedIndex);
        Vector a6 = VectorFactory.subVector(a5, a2);
        double a7 = a5.get(removedIndex);
        Matrix a8 = a4.minus(new OuterProduct(a6.scaled(1.0 / a7), a6));
        return a8;
    }

    private MarkowitzCriticalLineUtils() {
        MarkowitzCriticalLineUtils a2;
    }

    public static Matrix getDeletedInvTruncMat(Matrix oldInv, int[] oldAssetList, int removedAssetIndex) {
        return MarkowitzCriticalLineUtils.reduceInverseByOneRowColumn(oldInv, removedAssetIndex + 1);
    }
}

