/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teneighty.heap.AbstractLinkedHeap;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FibonacciHeap<TKey, TValue>
extends AbstractLinkedHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Iterable<Heap.Entry<TKey, TValue>>,
Serializable {
    private FibonacciHeapEntry<TKey, TValue> minimum = null;
    private AbstractLinkedHeap.HeapReference source_heap;
    private int size = 0;
    private static final long serialVersionUID = 9802348L;
    private Comparator<? super TKey> comp;
    private volatile int mod_count = 0;

    @Override
    public Heap.Entry<TKey, TValue> extractMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FibonacciHeapEntry<TKey, TValue> a2 = this.minimum;
        if (a2.child != null) {
            FibonacciHeapEntry a3;
            FibonacciHeapEntry a4 = a3 = a2.child;
            do {
                a4.parent = null;
            } while ((a4 = a4.right) != a3);
            this.minimum.left.right = a3.right;
            a3.right.left = this.minimum.left;
            this.minimum.left = a3;
            a3.right = this.minimum;
        }
        a2.left.right = a2.right;
        a2.right.left = a2.left;
        if (a2 == a2.right) {
            this.minimum = null;
        } else {
            this.minimum = a2.right;
            this.consolidate();
        }
        --this.size;
        ++this.mod_count;
        a2.clearSourceReference();
        return a2;
    }

    @Override
    public boolean holdsEntry(Heap.Entry<TKey, TValue> e2) throws NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!e2.getClass().equals(FibonacciHeapEntry.class)) {
            return false;
        }
        FibonacciHeapEntry a2 = (FibonacciHeapEntry)e2;
        return a2.isContainedBy(this);
    }

    private void cascadingCut(FibonacciHeapEntry<TKey, TValue> a2) {
        FibonacciHeapEntry a3 = a2.parent;
        if (a3 != null) {
            if (!a2.marked) {
                a2.marked = true;
            } else {
                FibonacciHeap a4;
                a4.cut(a2, a3);
                a4.cascadingCut(a3);
            }
        }
    }

    @Override
    public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.minimum;
    }

    public FibonacciHeap(Comparator<? super TKey> comp) {
        this.comp = comp;
        this.source_heap = new AbstractLinkedHeap.HeapReference(this);
    }

    @Override
    public Comparator<? super TKey> getComparator() {
        return this.comp;
    }

    private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
        FibonacciHeap a3;
        a3.comp = (Comparator)a2.readObject();
        int a4 = a2.readInt();
        a3.source_heap = new AbstractLinkedHeap.HeapReference(a3);
        for (int a5 = 0; a5 < a4; ++a5) {
            Object a6 = a2.readObject();
            Object a7 = a2.readObject();
            a3.insert(a6, a7);
        }
    }

    private void decreaseKeyImpl(FibonacciHeapEntry<TKey, TValue> a2) {
        FibonacciHeap a3;
        FibonacciHeapEntry a4 = a2.parent;
        if (a4 != null && a3.compare(a2, a4) < 0) {
            a3.cut(a2, a4);
            a3.cascadingCut(a4);
        }
        if (a3.compare(a2, a3.minimum) < 0) {
            a3.minimum = a2;
        }
        ++a3.mod_count;
    }

    private void consolidate() {
        FibonacciHeapEntry a2;
        FibonacciHeap a3;
        int a4 = (int)Math.floor(Math.log(a3.size) / Math.log(2.0)) + 2;
        FibonacciHeapEntry[] a5 = new FibonacciHeapEntry[a4];
        FibonacciHeapEntry a6 = a2 = a3.minimum;
        do {
            FibonacciHeapEntry a7;
            int a8;
            if (a5[a8 = a7.degree] == (a7 = a6)) continue;
            while (a5[a8] != null) {
                FibonacciHeapEntry a9 = a5[a8];
                if (a3.compare(a9, a7) < 0) {
                    FibonacciHeapEntry a10 = a7;
                    a7 = a9;
                    a9 = a10;
                }
                a3.link(a9, a7);
                a2 = a7;
                a6 = a7;
                a5[a8] = null;
                ++a8;
            }
            a5[a8] = a7;
        } while ((a6 = a6.right) != a2);
        a3.minimum = a2;
        a6 = a2;
        do {
            if (a3.compare(a6, a3.minimum) >= 0) continue;
            a3.minimum = a6;
        } while ((a6 = a6.right) != a2);
    }

    @Override
    public void delete(Heap.Entry<TKey, TValue> e2) throws IllegalArgumentException, NullPointerException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        FibonacciHeapEntry a2 = (FibonacciHeapEntry)e2;
        a2.is_infinite = true;
        this.decreaseKeyImpl(a2);
        this.extractMinimum();
        a2.is_infinite = false;
    }

    @Override
    public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws ClassCastException, NullPointerException {
        FibonacciHeapEntry<TKey, TValue> a2 = new FibonacciHeapEntry<TKey, TValue>(key, value, this.source_heap);
        a2.degree = 0;
        a2.marked = false;
        a2.right = a2;
        a2.left = a2.right;
        a2.parent = null;
        a2.child = null;
        if (this.minimum == null) {
            this.minimum = a2;
        } else {
            int a3 = this.compare(a2, this.minimum);
            this.minimum.right.left = a2;
            a2.right = this.minimum.right;
            this.minimum.right = a2;
            a2.left = this.minimum;
            if (a3 < 0) {
                this.minimum = a2;
            }
        }
        ++this.size;
        ++this.mod_count;
        return a2;
    }

    @Override
    public Iterator<Heap.Entry<TKey, TValue>> iterator() {
        return new EntryIterator();
    }

    @Override
    public void clear() {
        this.minimum = null;
        this.size = 0;
        ++this.mod_count;
        this.source_heap.clearHeap();
        this.source_heap = new AbstractLinkedHeap.HeapReference(this);
    }

    private void cut(FibonacciHeapEntry<TKey, TValue> a2, FibonacciHeapEntry<TKey, TValue> a3) {
        FibonacciHeap a4;
        a3.child = a2.right == a2 ? null : a2.right;
        a2.left.right = a2.right;
        a2.right.left = a2.left;
        --a3.degree;
        a4.minimum.right.left = a2;
        a2.right = a4.minimum.right;
        a4.minimum.right = a2;
        a2.left = a4.minimum;
        a2.parent = null;
        a2.marked = false;
    }

    public FibonacciHeap() {
        this(null);
    }

    private void link(FibonacciHeapEntry<TKey, TValue> a2, FibonacciHeapEntry<TKey, TValue> a3) {
        a2.left.right = a2.right;
        a2.right.left = a2.left;
        if (a3.child == null) {
            a2.right = a2;
            a2.left = a2;
            a3.child = a2;
        } else {
            a2.right = a3.child.right;
            a2.left = a3.child;
            a3.child.right.left = a2;
            a3.child.right = a2;
        }
        a2.parent = a3;
        ++a3.degree;
        a2.marked = false;
    }

    private void writeObject(ObjectOutputStream a2) throws IOException {
        FibonacciHeap a3;
        a2.writeObject(a3.comp);
        a2.writeInt(a3.size);
        EntryIterator a4 = a3.new EntryIterator();
        Heap.Entry a5 = null;
        while (a4.hasNext()) {
            try {
                a5 = (Heap.Entry)a4.next();
                a2.writeObject(a5.getKey());
                a2.writeObject(a5.getValue());
            }
            catch (ConcurrentModificationException a6) {
                throw (IOException)new IOException("Heap structure changed during serialization").initCause(a6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void union(Heap<TKey, TValue> other) throws ClassCastException, NullPointerException, IllegalArgumentException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this == other) {
            throw new IllegalArgumentException();
        }
        if (other.isEmpty()) {
            return;
        }
        if (other.getClass().equals(FibonacciHeap.class)) {
            FibonacciHeap a2 = (FibonacciHeap)other;
            try {
                int a3 = 0;
                if (this.minimum != null && a2.minimum != null) {
                    a3 = this.compare(a2.minimum, this.minimum);
                }
                this.minimum.left.right = a2.minimum.right;
                a2.minimum.right.left = this.minimum.left;
                this.minimum.left = a2.minimum;
                a2.minimum.right = this.minimum;
                if (a3 < 0) {
                    this.minimum = a2.minimum;
                }
                this.size += a2.size;
                ++this.mod_count;
                a2.source_heap.setHeap(this);
                a2.source_heap = new AbstractLinkedHeap.HeapReference(a2);
            }
            finally {
                a2.clear();
            }
        } else {
            throw new ClassCastException();
        }
    }

    @Override
    public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey k2) throws IllegalArgumentException, ClassCastException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        FibonacciHeapEntry a2 = (FibonacciHeapEntry)e2;
        if (this.compareKeys(k2, a2.getKey()) > 0) {
            throw new IllegalArgumentException();
        }
        a2.setKey(k2);
        this.decreaseKeyImpl(a2);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FibonacciHeapEntry<TKey, TValue>
    extends AbstractLinkedHeap.AbstractLinkedHeapEntry<TKey, TValue>
    implements Heap.Entry<TKey, TValue>,
    Serializable {
        transient FibonacciHeapEntry<TKey, TValue> child;
        transient int degree;
        transient FibonacciHeapEntry<TKey, TValue> left;
        transient FibonacciHeapEntry<TKey, TValue> parent;
        transient FibonacciHeapEntry<TKey, TValue> right;
        transient boolean marked;
        private static final long serialVersionUID = 2348L;

        FibonacciHeapEntry(TKey a2, TValue a3, AbstractLinkedHeap.HeapReference a4) {
            super(a2, a3, a4);
            FibonacciHeapEntry a5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Heap.Entry<TKey, TValue>> {
        private int my_mod_count;
        private FibonacciHeapEntry<TKey, TValue> next;

        EntryIterator() {
            EntryIterator a2;
            a2.next = a2.FibonacciHeap.this.minimum;
            a2.my_mod_count = a2.FibonacciHeap.this.mod_count;
        }

        @Override
        public boolean hasNext() {
            if (this.my_mod_count != FibonacciHeap.this.mod_count) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        private FibonacciHeapEntry<TKey, TValue> getSuccessor(FibonacciHeapEntry<TKey, TValue> a2) {
            if (a2.child != null) {
                return a2.child;
            }
            do {
                EntryIterator a3;
                FibonacciHeapEntry a4;
                FibonacciHeapEntry fibonacciHeapEntry = a4 = a2.parent == null ? a3.FibonacciHeap.this.minimum : a2.parent.child;
                if (a2.right == a4) continue;
                return a2.right;
            } while ((a2 = a2.parent) != null);
            return null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Heap.Entry<TKey, TValue> next() throws NoSuchElementException, ConcurrentModificationException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FibonacciHeapEntry a2 = this.next;
            this.next = this.getSuccessor(this.next);
            return a2;
        }
    }
}

