/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.FieldUtils;

public final class SkipDateTimeField
extends DelegatedDateTimeField {
    private transient int iMinValue;
    private final Chronology iChronology;
    private static final long serialVersionUID = -8869148464118507846L;
    private final int iSkip;

    private Object readResolve() {
        SkipDateTimeField a2;
        return a2.getType().getField(a2.iChronology);
    }

    public SkipDateTimeField(Chronology arg0, DateTimeField arg1, int arg2) {
        super(arg1);
        this.iChronology = arg0;
        int n = super.getMinimumValue();
        this.iMinValue = n < arg2 ? n - 1 : (n == arg2 ? arg2 + 1 : n);
        this.iSkip = arg2;
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, this.iMinValue, this.getMaximumValue());
        if (arg1 <= this.iSkip) {
            if (arg1 == this.iSkip) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)arg1, null, null);
            }
            ++arg1;
        }
        return super.set(arg0, arg1);
    }

    public int getMinimumValue() {
        return this.iMinValue;
    }

    public SkipDateTimeField(Chronology arg0, DateTimeField arg1) {
        this(arg0, arg1, 0);
    }

    public int get(long arg0) {
        int n = super.get(arg0);
        if (n <= this.iSkip) {
            --n;
        }
        return n;
    }
}

