/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public class PreciseDurationField
extends BaseDurationField {
    private static final long serialVersionUID = -8346152187724495365L;
    private final long iUnitMillis;

    public final boolean isPrecise() {
        return true;
    }

    public long getDifferenceAsLong(long arg0, long arg1) {
        long l2 = FieldUtils.safeSubtract(arg0, arg1);
        return l2 / this.iUnitMillis;
    }

    public long getMillis(long arg0, long arg1) {
        return FieldUtils.safeMultiply(arg0, this.iUnitMillis);
    }

    public long add(long arg0, int arg1) {
        long l2 = (long)arg1 * this.iUnitMillis;
        return FieldUtils.safeAdd(arg0, l2);
    }

    public long getMillis(int arg0, long arg1) {
        return (long)arg0 * this.iUnitMillis;
    }

    public int hashCode() {
        long l2 = this.iUnitMillis;
        int n = (int)(l2 ^ l2 >>> 32);
        return n += this.getType().hashCode();
    }

    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof PreciseDurationField) {
            PreciseDurationField preciseDurationField = (PreciseDurationField)arg0;
            return this.getType() == preciseDurationField.getType() && this.iUnitMillis == preciseDurationField.iUnitMillis;
        }
        return false;
    }

    public PreciseDurationField(DurationFieldType arg0, long arg1) {
        super(arg0);
        this.iUnitMillis = arg1;
    }

    public long add(long arg0, long arg1) {
        long l2 = FieldUtils.safeMultiply(arg1, this.iUnitMillis);
        return FieldUtils.safeAdd(arg0, l2);
    }

    public long getValueAsLong(long arg0, long arg1) {
        return arg0 / this.iUnitMillis;
    }
}

