/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;

public abstract class PreciseDurationDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 5004523158306266035L;
    private final DurationField iUnitField;
    final long iUnitMillis;

    public DurationField getDurationField() {
        return this.iUnitField;
    }

    public boolean isLenient() {
        return false;
    }

    public PreciseDurationDateTimeField(DateTimeFieldType arg0, DurationField arg1) {
        super(arg0);
        if (!arg1.isPrecise()) {
            throw new IllegalArgumentException("Unit duration field must be precise");
        }
        this.iUnitMillis = arg1.getUnitMillis();
        if (this.iUnitMillis < 1L) {
            throw new IllegalArgumentException("The unit milliseconds must be at least 1");
        }
        this.iUnitField = arg1;
    }

    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    public int getMinimumValue() {
        return 0;
    }

    public long roundCeiling(long arg0) {
        if (arg0 > 0L) {
            return --arg0 - arg0 % this.iUnitMillis + this.iUnitMillis;
        }
        return arg0 - arg0 % this.iUnitMillis;
    }

    public long remainder(long arg0) {
        if (arg0 >= 0L) {
            return arg0 % this.iUnitMillis;
        }
        return (arg0 + 1L) % this.iUnitMillis + this.iUnitMillis - 1L;
    }

    protected int getMaximumValueForSet(long arg0, int arg1) {
        return this.getMaximumValue(arg0);
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, this.getMinimumValue(), this.getMaximumValueForSet(arg0, arg1));
        return arg0 + (long)(arg1 - this.get(arg0)) * this.iUnitMillis;
    }

    public long roundFloor(long arg0) {
        if (arg0 >= 0L) {
            return arg0 - arg0 % this.iUnitMillis;
        }
        return ++arg0 - arg0 % this.iUnitMillis - this.iUnitMillis;
    }
}

