/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.PreciseDurationDateTimeField;

public class PreciseDateTimeField
extends PreciseDurationDateTimeField {
    private final int iRange;
    private final DurationField iRangeField;
    private static final long serialVersionUID = -5586801265774496376L;

    public long addWrapField(long arg0, int arg1) {
        int n = this.get(arg0);
        int n2 = FieldUtils.getWrappedValue(n, arg1, this.getMinimumValue(), this.getMaximumValue());
        return arg0 + (long)(n2 - n) * this.getUnitMillis();
    }

    public int get(long arg0) {
        if (arg0 >= 0L) {
            return (int)(arg0 / this.getUnitMillis() % (long)this.iRange);
        }
        return this.iRange - 1 + (int)((arg0 + 1L) / this.getUnitMillis() % (long)this.iRange);
    }

    public int getRange() {
        return this.iRange;
    }

    public PreciseDateTimeField(DateTimeFieldType arg0, DurationField arg1, DurationField arg2) {
        super(arg0, arg1);
        if (!arg2.isPrecise()) {
            throw new IllegalArgumentException("Range duration field must be precise");
        }
        long l2 = arg2.getUnitMillis();
        this.iRange = (int)(l2 / this.getUnitMillis());
        if (this.iRange < 2) {
            throw new IllegalArgumentException("The effective range must be at least 2");
        }
        this.iRangeField = arg2;
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, this.getMinimumValue(), this.getMaximumValue());
        return arg0 + (long)(arg1 - this.get(arg0)) * this.iUnitMillis;
    }

    public DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    public int getMaximumValue() {
        return this.iRange - 1;
    }
}

