/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;

public abstract class AbstractPartialFieldProperty {
    public abstract int get();

    public int getMaximumValueOverall() {
        return this.getField().getMaximumValue();
    }

    public int getMaximumValue() {
        return this.getField().getMaximumValue(this.getReadablePartial());
    }

    public int hashCode() {
        int n = 19;
        n = 13 * n + this.get();
        n = 13 * n + this.getFieldType().hashCode();
        n = 13 * n + this.getReadablePartial().getChronology().hashCode();
        return n;
    }

    public String getAsText() {
        return this.getAsText(null);
    }

    public String getAsText(Locale arg0) {
        return this.getField().getAsText(this.getReadablePartial(), this.get(), arg0);
    }

    protected AbstractPartialFieldProperty() {
    }

    protected abstract ReadablePartial getReadablePartial();

    public DurationField getRangeDurationField() {
        return this.getField().getRangeDurationField();
    }

    public int compareTo(ReadablePartial arg0) {
        int n;
        if (arg0 == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int n2 = this.get();
        if (n2 < (n = arg0.get(this.getFieldType()))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public DurationField getDurationField() {
        return this.getField().getDurationField();
    }

    public String toString() {
        return "Property[" + this.getName() + "]";
    }

    public int getMaximumTextLength(Locale arg0) {
        return this.getField().getMaximumTextLength(arg0);
    }

    public String getAsShortText() {
        return this.getAsShortText(null);
    }

    public int getMinimumValueOverall() {
        return this.getField().getMinimumValue();
    }

    public int getMinimumValue() {
        return this.getField().getMinimumValue(this.getReadablePartial());
    }

    public String getAsString() {
        return Integer.toString(this.get());
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof AbstractPartialFieldProperty)) {
            return false;
        }
        AbstractPartialFieldProperty abstractPartialFieldProperty = (AbstractPartialFieldProperty)arg0;
        return this.get() == abstractPartialFieldProperty.get() && this.getFieldType() == abstractPartialFieldProperty.getFieldType() && FieldUtils.equals(this.getReadablePartial().getChronology(), abstractPartialFieldProperty.getReadablePartial().getChronology());
    }

    public int getMaximumShortTextLength(Locale arg0) {
        return this.getField().getMaximumShortTextLength(arg0);
    }

    public DateTimeFieldType getFieldType() {
        return this.getField().getType();
    }

    public String getName() {
        return this.getField().getName();
    }

    public abstract DateTimeField getField();

    public int compareTo(ReadableInstant arg0) {
        int n;
        if (arg0 == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int n2 = this.get();
        if (n2 < (n = arg0.get(this.getFieldType()))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public String getAsShortText(Locale arg0) {
        return this.getField().getAsShortText(this.getReadablePartial(), this.get(), arg0);
    }
}

