/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LimitChronology
extends AssembledChronology {
    final DateTime iLowerLimit;
    final DateTime iUpperLimit;
    private static final long serialVersionUID = 7670866536893052522L;
    private transient LimitChronology iWithUTC;

    @Override
    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3) throws IllegalArgumentException {
        long l2 = this.getBase().getDateTimeMillis(arg0, arg1, arg2, arg3);
        this.checkLimits(l2, "resulting");
        return l2;
    }

    @Override
    public String toString() {
        return "LimitChronology[" + this.getBase().toString() + ", " + (this.getLowerLimit() == null ? "NoLimit" : this.getLowerLimit().toString()) + ", " + (this.getUpperLimit() == null ? "NoLimit" : this.getUpperLimit().toString()) + ']';
    }

    public DateTime getUpperLimit() {
        return this.iUpperLimit;
    }

    @Override
    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) throws IllegalArgumentException {
        long l2 = this.getBase().getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        this.checkLimits(l2, "resulting");
        return l2;
    }

    @Override
    public long getDateTimeMillis(long arg0, int arg1, int arg2, int arg3, int arg4) throws IllegalArgumentException {
        this.checkLimits(arg0, null);
        arg0 = this.getBase().getDateTimeMillis(arg0, arg1, arg2, arg3, arg4);
        this.checkLimits(arg0, "resulting");
        return arg0;
    }

    public DateTime getLowerLimit() {
        return this.iLowerLimit;
    }

    @Override
    protected void assemble(AssembledChronology.Fields arg0) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        arg0.eras = this.convertField(arg0.eras, hashMap);
        arg0.centuries = this.convertField(arg0.centuries, hashMap);
        arg0.years = this.convertField(arg0.years, hashMap);
        arg0.months = this.convertField(arg0.months, hashMap);
        arg0.weekyears = this.convertField(arg0.weekyears, hashMap);
        arg0.weeks = this.convertField(arg0.weeks, hashMap);
        arg0.days = this.convertField(arg0.days, hashMap);
        arg0.halfdays = this.convertField(arg0.halfdays, hashMap);
        arg0.hours = this.convertField(arg0.hours, hashMap);
        arg0.minutes = this.convertField(arg0.minutes, hashMap);
        arg0.seconds = this.convertField(arg0.seconds, hashMap);
        arg0.millis = this.convertField(arg0.millis, hashMap);
        arg0.year = this.convertField(arg0.year, hashMap);
        arg0.yearOfEra = this.convertField(arg0.yearOfEra, hashMap);
        arg0.yearOfCentury = this.convertField(arg0.yearOfCentury, hashMap);
        arg0.centuryOfEra = this.convertField(arg0.centuryOfEra, hashMap);
        arg0.era = this.convertField(arg0.era, hashMap);
        arg0.dayOfWeek = this.convertField(arg0.dayOfWeek, hashMap);
        arg0.dayOfMonth = this.convertField(arg0.dayOfMonth, hashMap);
        arg0.dayOfYear = this.convertField(arg0.dayOfYear, hashMap);
        arg0.monthOfYear = this.convertField(arg0.monthOfYear, hashMap);
        arg0.weekOfWeekyear = this.convertField(arg0.weekOfWeekyear, hashMap);
        arg0.weekyear = this.convertField(arg0.weekyear, hashMap);
        arg0.weekyearOfCentury = this.convertField(arg0.weekyearOfCentury, hashMap);
        arg0.millisOfSecond = this.convertField(arg0.millisOfSecond, hashMap);
        arg0.millisOfDay = this.convertField(arg0.millisOfDay, hashMap);
        arg0.secondOfMinute = this.convertField(arg0.secondOfMinute, hashMap);
        arg0.secondOfDay = this.convertField(arg0.secondOfDay, hashMap);
        arg0.minuteOfHour = this.convertField(arg0.minuteOfHour, hashMap);
        arg0.minuteOfDay = this.convertField(arg0.minuteOfDay, hashMap);
        arg0.hourOfDay = this.convertField(arg0.hourOfDay, hashMap);
        arg0.hourOfHalfday = this.convertField(arg0.hourOfHalfday, hashMap);
        arg0.clockhourOfDay = this.convertField(arg0.clockhourOfDay, hashMap);
        arg0.clockhourOfHalfday = this.convertField(arg0.clockhourOfHalfday, hashMap);
        arg0.halfdayOfDay = this.convertField(arg0.halfdayOfDay, hashMap);
    }

    @Override
    public Chronology withUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    @Override
    public Chronology withZone(DateTimeZone arg0) {
        Serializable serializable;
        BaseDateTime baseDateTime;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        if (arg0 == DateTimeZone.UTC && this.iWithUTC != null) {
            return this.iWithUTC;
        }
        DateTime dateTime = this.iLowerLimit;
        if (dateTime != null) {
            baseDateTime = dateTime.toMutableDateTime();
            ((MutableDateTime)baseDateTime).setZoneRetainFields(arg0);
            dateTime = baseDateTime.toDateTime();
        }
        if ((baseDateTime = this.iUpperLimit) != null) {
            serializable = baseDateTime.toMutableDateTime();
            serializable.setZoneRetainFields(arg0);
            baseDateTime = serializable.toDateTime();
        }
        serializable = LimitChronology.getInstance(this.getBase().withZone(arg0), dateTime, baseDateTime);
        if (arg0 == DateTimeZone.UTC) {
            this.iWithUTC = serializable;
        }
        return serializable;
    }

    public static LimitChronology getInstance(Chronology arg0, ReadableDateTime arg1, ReadableDateTime arg2) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        arg1 = arg1 == null ? null : arg1.toDateTime();
        ReadableDateTime readableDateTime = arg2 = arg2 == null ? null : arg2.toDateTime();
        if (arg1 != null && arg2 != null && !arg1.isBefore(arg2)) {
            throw new IllegalArgumentException("The lower limit must be come before than the upper limit");
        }
        return new LimitChronology(arg0, (DateTime)arg1, (DateTime)arg2);
    }

    private LimitChronology(Chronology a2, DateTime a3, DateTime a4) {
        super(a2, null);
        LimitChronology a5;
        a5.iLowerLimit = a3;
        a5.iUpperLimit = a4;
    }

    public int hashCode() {
        int n = 317351877;
        n += this.getLowerLimit() != null ? this.getLowerLimit().hashCode() : 0;
        n += this.getUpperLimit() != null ? this.getUpperLimit().hashCode() : 0;
        return n += this.getBase().hashCode() * 7;
    }

    private DateTimeField convertField(DateTimeField a2, HashMap<Object, Object> a3) {
        LimitChronology a4;
        if (a2 == null || !a2.isSupported()) {
            return a2;
        }
        if (a3.containsKey(a2)) {
            return (DateTimeField)a3.get(a2);
        }
        LimitDateTimeField limitDateTimeField = a4.new LimitDateTimeField(a2, a4.convertField(a2.getDurationField(), a3), a4.convertField(a2.getRangeDurationField(), a3), a4.convertField(a2.getLeapDurationField(), a3));
        a3.put(a2, limitDateTimeField);
        return limitDateTimeField;
    }

    private DurationField convertField(DurationField a2, HashMap<Object, Object> a3) {
        LimitChronology a4;
        if (a2 == null || !a2.isSupported()) {
            return a2;
        }
        if (a3.containsKey(a2)) {
            return (DurationField)a3.get(a2);
        }
        LimitDurationField limitDurationField = a4.new LimitDurationField(a2);
        a3.put(a2, limitDurationField);
        return limitDurationField;
    }

    void checkLimits(long a2, String a3) {
        LimitChronology a4;
        DateTime dateTime = a4.iLowerLimit;
        if (dateTime != null && a2 < dateTime.getMillis()) {
            throw a4.new LimitException(a3, true);
        }
        dateTime = a4.iUpperLimit;
        if (dateTime != null && a2 >= dateTime.getMillis()) {
            throw a4.new LimitException(a3, false);
        }
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof LimitChronology)) {
            return false;
        }
        LimitChronology limitChronology = (LimitChronology)arg0;
        return this.getBase().equals(limitChronology.getBase()) && FieldUtils.equals(this.getLowerLimit(), limitChronology.getLowerLimit()) && FieldUtils.equals(this.getUpperLimit(), limitChronology.getUpperLimit());
    }

    private class LimitDateTimeField
    extends DecoratedDateTimeField {
        private final DurationField iDurationField;
        private final DurationField iLeapDurationField;
        private static final long serialVersionUID = -2435306746995699312L;
        private final DurationField iRangeDurationField;

        public long roundCeiling(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().roundCeiling(arg0);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public long set(long arg0, int arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().set(arg0, arg1);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public int getMinimumValue(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            return this.getWrappedField().getMinimumValue(arg0);
        }

        public int getMaximumValue(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            return this.getWrappedField().getMaximumValue(arg0);
        }

        public String getAsShortText(long arg0, Locale arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            return this.getWrappedField().getAsShortText(arg0, arg1);
        }

        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public boolean isLeap(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            return this.getWrappedField().isLeap(arg0);
        }

        public int getDifference(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg0, "minuend");
            LimitChronology.this.checkLimits(arg1, "subtrahend");
            return this.getWrappedField().getDifference(arg0, arg1);
        }

        public long set(long arg0, String arg1, Locale arg2) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().set(arg0, arg1, arg2);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public int getMaximumShortTextLength(Locale arg0) {
            return this.getWrappedField().getMaximumShortTextLength(arg0);
        }

        public long roundHalfEven(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().roundHalfEven(arg0);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public int get(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            return this.getWrappedField().get(arg0);
        }

        public long roundHalfFloor(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().roundHalfFloor(arg0);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        LimitDateTimeField(DateTimeField a3, DurationField a4, DurationField a5, DurationField a6) {
            LimitDateTimeField a7;
            super(a3, a3.getType());
            a7.iDurationField = a4;
            a7.iRangeDurationField = a5;
            a7.iLeapDurationField = a6;
        }

        public int getLeapAmount(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            return this.getWrappedField().getLeapAmount(arg0);
        }

        public long addWrapField(long arg0, int arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().addWrapField(arg0, arg1);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public long remainder(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().remainder(arg0);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public long add(long arg0, int arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().add(arg0, arg1);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg0, "minuend");
            LimitChronology.this.checkLimits(arg1, "subtrahend");
            return this.getWrappedField().getDifferenceAsLong(arg0, arg1);
        }

        public String getAsText(long arg0, Locale arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            return this.getWrappedField().getAsText(arg0, arg1);
        }

        public long add(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().add(arg0, arg1);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public int getMaximumTextLength(Locale arg0) {
            return this.getWrappedField().getMaximumTextLength(arg0);
        }

        public long roundHalfCeiling(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().roundHalfCeiling(arg0);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        public long roundFloor(long arg0) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().roundFloor(arg0);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }
    }

    private class LimitDurationField
    extends DecoratedDurationField {
        private static final long serialVersionUID = 8049297699408782284L;

        public long getValueAsLong(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg1, null);
            return this.getWrappedField().getValueAsLong(arg0, arg1);
        }

        LimitDurationField(DurationField a3) {
            LimitDurationField a4;
            super(a3, a3.getType());
        }

        public int getDifference(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg0, "minuend");
            LimitChronology.this.checkLimits(arg1, "subtrahend");
            return this.getWrappedField().getDifference(arg0, arg1);
        }

        public long add(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().add(arg0, arg1);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public int getValue(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg1, null);
            return this.getWrappedField().getValue(arg0, arg1);
        }

        public long getMillis(int arg0, long arg1) {
            LimitChronology.this.checkLimits(arg1, null);
            return this.getWrappedField().getMillis(arg0, arg1);
        }

        public long getMillis(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg1, null);
            return this.getWrappedField().getMillis(arg0, arg1);
        }

        public long add(long arg0, int arg1) {
            LimitChronology.this.checkLimits(arg0, null);
            long l2 = this.getWrappedField().add(arg0, arg1);
            LimitChronology.this.checkLimits(l2, "resulting");
            return l2;
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            LimitChronology.this.checkLimits(arg0, "minuend");
            LimitChronology.this.checkLimits(arg1, "subtrahend");
            return this.getWrappedField().getDifferenceAsLong(arg0, arg1);
        }
    }

    private class LimitException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -5924689995607498581L;
        private final boolean iIsLow;

        LimitException(String a3, boolean a4) {
            LimitException a5;
            super(a3);
            a5.iIsLow = a4;
        }

        public String toString() {
            return "IllegalArgumentException: " + this.getMessage();
        }

        public String getMessage() {
            StringBuffer stringBuffer = new StringBuffer(85);
            stringBuffer.append("The");
            String string = super.getMessage();
            if (string != null) {
                stringBuffer.append(' ');
                stringBuffer.append(string);
            }
            stringBuffer.append(" instant is ");
            DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
            dateTimeFormatter = dateTimeFormatter.withChronology(LimitChronology.this.getBase());
            if (this.iIsLow) {
                stringBuffer.append("below the supported minimum of ");
                dateTimeFormatter.printTo(stringBuffer, LimitChronology.this.getLowerLimit().getMillis());
            } else {
                stringBuffer.append("above the supported maximum of ");
                dateTimeFormatter.printTo(stringBuffer, LimitChronology.this.getUpperLimit().getMillis());
            }
            stringBuffer.append(" (");
            stringBuffer.append(LimitChronology.this.getBase());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

