/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.GJCacheKey;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.JulianChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class GJChronology
extends AssembledChronology {
    private long iCutoverMillis;
    private static final long serialVersionUID = -2545574827706931671L;
    private static final ConcurrentHashMap<GJCacheKey, GJChronology> cCache;
    private long iGapDuration;
    static final Instant DEFAULT_CUTOVER;
    private GregorianChronology iGregorianChronology;
    private JulianChronology iJulianChronology;
    private Instant iCutoverInstant;

    public int getMinimumDaysInFirstWeek() {
        return this.iGregorianChronology.getMinimumDaysInFirstWeek();
    }

    long julianToGregorianByYear(long a2) {
        GJChronology a3;
        return GJChronology.convertByYear(a2, a3.iJulianChronology, a3.iGregorianChronology);
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return GJChronology.getInstance(arg0, this.iCutoverInstant, this.getMinimumDaysInFirstWeek());
    }

    public Chronology withUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        Object[] objectArray = (Object[])this.getParam();
        JulianChronology julianChronology = (JulianChronology)objectArray[0];
        GregorianChronology gregorianChronology = (GregorianChronology)objectArray[1];
        Instant instant = (Instant)objectArray[2];
        this.iCutoverMillis = instant.getMillis();
        this.iJulianChronology = julianChronology;
        this.iGregorianChronology = gregorianChronology;
        this.iCutoverInstant = instant;
        if (this.getBase() != null) {
            return;
        }
        if (julianChronology.getMinimumDaysInFirstWeek() != gregorianChronology.getMinimumDaysInFirstWeek()) {
            throw new IllegalArgumentException();
        }
        this.iGapDuration = this.iCutoverMillis - this.julianToGregorianByYear(this.iCutoverMillis);
        arg0.copyFieldsFrom(gregorianChronology);
        if (gregorianChronology.millisOfDay().get(this.iCutoverMillis) == 0) {
            arg0.millisOfSecond = new CutoverField(julianChronology.millisOfSecond(), arg0.millisOfSecond, this.iCutoverMillis);
            arg0.millisOfDay = new CutoverField(julianChronology.millisOfDay(), arg0.millisOfDay, this.iCutoverMillis);
            arg0.secondOfMinute = new CutoverField(julianChronology.secondOfMinute(), arg0.secondOfMinute, this.iCutoverMillis);
            arg0.secondOfDay = new CutoverField(julianChronology.secondOfDay(), arg0.secondOfDay, this.iCutoverMillis);
            arg0.minuteOfHour = new CutoverField(julianChronology.minuteOfHour(), arg0.minuteOfHour, this.iCutoverMillis);
            arg0.minuteOfDay = new CutoverField(julianChronology.minuteOfDay(), arg0.minuteOfDay, this.iCutoverMillis);
            arg0.hourOfDay = new CutoverField(julianChronology.hourOfDay(), arg0.hourOfDay, this.iCutoverMillis);
            arg0.hourOfHalfday = new CutoverField(julianChronology.hourOfHalfday(), arg0.hourOfHalfday, this.iCutoverMillis);
            arg0.clockhourOfDay = new CutoverField(julianChronology.clockhourOfDay(), arg0.clockhourOfDay, this.iCutoverMillis);
            arg0.clockhourOfHalfday = new CutoverField(julianChronology.clockhourOfHalfday(), arg0.clockhourOfHalfday, this.iCutoverMillis);
            arg0.halfdayOfDay = new CutoverField(julianChronology.halfdayOfDay(), arg0.halfdayOfDay, this.iCutoverMillis);
        }
        arg0.era = new CutoverField(julianChronology.era(), arg0.era, this.iCutoverMillis);
        arg0.year = new ImpreciseCutoverField(julianChronology.year(), arg0.year, this.iCutoverMillis);
        arg0.years = arg0.year.getDurationField();
        arg0.yearOfEra = new ImpreciseCutoverField(julianChronology.yearOfEra(), arg0.yearOfEra, arg0.years, this.iCutoverMillis);
        arg0.centuryOfEra = new ImpreciseCutoverField(julianChronology.centuryOfEra(), arg0.centuryOfEra, this.iCutoverMillis);
        arg0.centuries = arg0.centuryOfEra.getDurationField();
        arg0.yearOfCentury = new ImpreciseCutoverField(julianChronology.yearOfCentury(), arg0.yearOfCentury, arg0.years, arg0.centuries, this.iCutoverMillis);
        arg0.monthOfYear = new ImpreciseCutoverField(julianChronology.monthOfYear(), arg0.monthOfYear, null, arg0.years, this.iCutoverMillis);
        arg0.months = arg0.monthOfYear.getDurationField();
        arg0.weekyear = new ImpreciseCutoverField(julianChronology.weekyear(), arg0.weekyear, null, this.iCutoverMillis, true);
        arg0.weekyears = arg0.weekyear.getDurationField();
        arg0.weekyearOfCentury = new ImpreciseCutoverField(julianChronology.weekyearOfCentury(), arg0.weekyearOfCentury, arg0.weekyears, arg0.centuries, this.iCutoverMillis);
        long l2 = gregorianChronology.year().roundCeiling(this.iCutoverMillis);
        arg0.dayOfYear = new CutoverField(julianChronology.dayOfYear(), arg0.dayOfYear, arg0.years, l2, false);
        l2 = gregorianChronology.weekyear().roundCeiling(this.iCutoverMillis);
        arg0.weekOfWeekyear = new CutoverField(julianChronology.weekOfWeekyear(), arg0.weekOfWeekyear, arg0.weekyears, l2, true);
        CutoverField cutoverField = new CutoverField(julianChronology.dayOfMonth(), arg0.dayOfMonth, this.iCutoverMillis);
        cutoverField.iRangeDurationField = arg0.months;
        arg0.dayOfMonth = cutoverField;
    }

    long gregorianToJulianByYear(long a2) {
        GJChronology a3;
        return GJChronology.convertByYear(a2, a3.iGregorianChronology, a3.iJulianChronology);
    }

    private GJChronology(Chronology a2, JulianChronology a3, GregorianChronology a4, Instant a5) {
        super(a2, new Object[]{a3, a4, a5});
        GJChronology a6;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append("GJChronology");
        stringBuffer.append('[');
        stringBuffer.append(this.getZone().getID());
        if (this.iCutoverMillis != DEFAULT_CUTOVER.getMillis()) {
            stringBuffer.append(",cutover=");
            DateTimeFormatter dateTimeFormatter = this.withUTC().dayOfYear().remainder(this.iCutoverMillis) == 0L ? ISODateTimeFormat.date() : ISODateTimeFormat.dateTime();
            dateTimeFormatter.withChronology(this.withUTC()).printTo(stringBuffer, this.iCutoverMillis);
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            stringBuffer.append(",mdfw=");
            stringBuffer.append(this.getMinimumDaysInFirstWeek());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private GJChronology(JulianChronology a2, GregorianChronology a3, Instant a4) {
        super(null, new Object[]{a2, a3, a4});
        GJChronology a5;
    }

    public static GJChronology getInstance(DateTimeZone arg0, long arg1, int arg2) {
        Instant instant = arg1 == DEFAULT_CUTOVER.getMillis() ? null : new Instant(arg1);
        return GJChronology.getInstance(arg0, instant, arg2);
    }

    public static GJChronology getInstanceUTC() {
        return GJChronology.getInstance(DateTimeZone.UTC, DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance(DateTimeZone arg0, ReadableInstant arg1, int arg2) {
        Object object;
        Instant instant;
        arg0 = DateTimeUtils.getZone(arg0);
        if (arg1 == null) {
            instant = DEFAULT_CUTOVER;
        } else {
            instant = arg1.toInstant();
            object = new LocalDate(instant.getMillis(), (Chronology)GregorianChronology.getInstance(arg0));
            if (((LocalDate)object).getYear() <= 0) {
                throw new IllegalArgumentException("Cutover too early. Must be on or after 0001-01-01.");
            }
        }
        object = new GJCacheKey(arg0, instant, arg2);
        GJChronology gJChronology = cCache.get(object);
        if (gJChronology == null) {
            if (arg0 == DateTimeZone.UTC) {
                gJChronology = new GJChronology(JulianChronology.getInstance(arg0, arg2), GregorianChronology.getInstance(arg0, arg2), instant);
            } else {
                gJChronology = GJChronology.getInstance(DateTimeZone.UTC, instant, arg2);
                gJChronology = new GJChronology(ZonedChronology.getInstance(gJChronology, arg0), gJChronology.iJulianChronology, gJChronology.iGregorianChronology, gJChronology.iCutoverInstant);
            }
            GJChronology gJChronology2 = cCache.putIfAbsent((GJCacheKey)object, gJChronology);
            if (gJChronology2 != null) {
                gJChronology = gJChronology2;
            }
        }
        return gJChronology;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof GJChronology) {
            GJChronology gJChronology = (GJChronology)arg0;
            return this.iCutoverMillis == gJChronology.iCutoverMillis && this.getMinimumDaysInFirstWeek() == gJChronology.getMinimumDaysInFirstWeek() && this.getZone().equals(gJChronology.getZone());
        }
        return false;
    }

    public Instant getGregorianCutover() {
        return this.iCutoverInstant;
    }

    private Object readResolve() {
        GJChronology a2;
        return GJChronology.getInstance(a2.getZone(), a2.iCutoverInstant, a2.getMinimumDaysInFirstWeek());
    }

    static {
        DEFAULT_CUTOVER = new Instant(-12219292800000L);
        cCache = new ConcurrentHashMap();
    }

    public int hashCode() {
        return "GJ".hashCode() * 11 + this.getZone().hashCode() + this.getMinimumDaysInFirstWeek() + this.iCutoverInstant.hashCode();
    }

    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) throws IllegalArgumentException {
        long l2;
        block5: {
            Chronology chronology = this.getBase();
            if (chronology != null) {
                return chronology.getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            }
            try {
                l2 = this.iGregorianChronology.getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            }
            catch (IllegalFieldValueException illegalFieldValueException) {
                if (arg1 != 2 || arg2 != 29) {
                    throw illegalFieldValueException;
                }
                l2 = this.iGregorianChronology.getDateTimeMillis(arg0, arg1, 28, arg3, arg4, arg5, arg6);
                if (l2 < this.iCutoverMillis) break block5;
                throw illegalFieldValueException;
            }
        }
        if (l2 < this.iCutoverMillis && (l2 = this.iJulianChronology.getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6)) >= this.iCutoverMillis) {
            throw new IllegalArgumentException("Specified date does not exist");
        }
        return l2;
    }

    public DateTimeZone getZone() {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getZone();
        }
        return DateTimeZone.UTC;
    }

    private static long convertByYear(long a2, Chronology a3, Chronology a4) {
        return a4.getDateTimeMillis(a3.year().get(a2), a3.monthOfYear().get(a2), a3.dayOfMonth().get(a2), a3.millisOfDay().get(a2));
    }

    long julianToGregorianByWeekyear(long a2) {
        GJChronology a3;
        return GJChronology.convertByWeekyear(a2, a3.iJulianChronology, a3.iGregorianChronology);
    }

    private static long convertByWeekyear(long a2, Chronology a3, Chronology a4) {
        long l2 = a4.weekyear().set(0L, a3.weekyear().get(a2));
        l2 = a4.weekOfWeekyear().set(l2, a3.weekOfWeekyear().get(a2));
        l2 = a4.dayOfWeek().set(l2, a3.dayOfWeek().get(a2));
        l2 = a4.millisOfDay().set(l2, a3.millisOfDay().get(a2));
        return l2;
    }

    public static GJChronology getInstance(DateTimeZone arg0) {
        return GJChronology.getInstance(arg0, DEFAULT_CUTOVER, 4);
    }

    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3) throws IllegalArgumentException {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getDateTimeMillis(arg0, arg1, arg2, arg3);
        }
        long l2 = this.iGregorianChronology.getDateTimeMillis(arg0, arg1, arg2, arg3);
        if (l2 < this.iCutoverMillis && (l2 = this.iJulianChronology.getDateTimeMillis(arg0, arg1, arg2, arg3)) >= this.iCutoverMillis) {
            throw new IllegalArgumentException("Specified date does not exist");
        }
        return l2;
    }

    public static GJChronology getInstance() {
        return GJChronology.getInstance(DateTimeZone.getDefault(), DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance(DateTimeZone arg0, ReadableInstant arg1) {
        return GJChronology.getInstance(arg0, arg1, 4);
    }

    long gregorianToJulianByWeekyear(long a2) {
        GJChronology a3;
        return GJChronology.convertByWeekyear(a2, a3.iGregorianChronology, a3.iJulianChronology);
    }

    private static class LinkedDurationField
    extends DecoratedDurationField {
        private final ImpreciseCutoverField iField;
        private static final long serialVersionUID = 4097975388007713084L;

        public int getDifference(long arg0, long arg1) {
            return this.iField.getDifference(arg0, arg1);
        }

        public long add(long arg0, int arg1) {
            return this.iField.add(arg0, arg1);
        }

        public long add(long arg0, long arg1) {
            return this.iField.add(arg0, arg1);
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            return this.iField.getDifferenceAsLong(arg0, arg1);
        }

        LinkedDurationField(DurationField a2, ImpreciseCutoverField a3) {
            super(a2, a2.getType());
            LinkedDurationField a4;
            a4.iField = a3;
        }
    }

    private final class ImpreciseCutoverField
    extends CutoverField {
        private static final long serialVersionUID = 3410248757173576441L;

        ImpreciseCutoverField(DateTimeField a3, DateTimeField a4, long a5) {
            a6(a3, a4, null, a5, false);
            ImpreciseCutoverField a6;
        }

        ImpreciseCutoverField(DateTimeField a3, DateTimeField a4, DurationField a5, DurationField a6, long a7) {
            a8(a3, a4, a5, a7, false);
            ImpreciseCutoverField a8;
            a8.iRangeDurationField = a6;
        }

        public long add(long arg0, int arg1) {
            if (arg0 >= this.iCutover) {
                if ((arg0 = this.iGregorianField.add(arg0, arg1)) < this.iCutover && arg0 + GJChronology.this.iGapDuration < this.iCutover) {
                    if (this.iConvertByWeekyear) {
                        int n = GJChronology.this.iGregorianChronology.weekyear().get(arg0);
                        if (n <= 0) {
                            arg0 = GJChronology.this.iGregorianChronology.weekyear().add(arg0, -1);
                        }
                    } else {
                        int n = GJChronology.this.iGregorianChronology.year().get(arg0);
                        if (n <= 0) {
                            arg0 = GJChronology.this.iGregorianChronology.year().add(arg0, -1);
                        }
                    }
                    arg0 = this.gregorianToJulian(arg0);
                }
            } else if ((arg0 = this.iJulianField.add(arg0, arg1)) >= this.iCutover && arg0 - GJChronology.this.iGapDuration >= this.iCutover) {
                arg0 = this.julianToGregorian(arg0);
            }
            return arg0;
        }

        public int getMinimumValue(long arg0) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.getMinimumValue(arg0);
            }
            return this.iJulianField.getMinimumValue(arg0);
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            if (arg0 >= this.iCutover) {
                if (arg1 >= this.iCutover) {
                    return this.iGregorianField.getDifferenceAsLong(arg0, arg1);
                }
                arg0 = this.gregorianToJulian(arg0);
                return this.iJulianField.getDifferenceAsLong(arg0, arg1);
            }
            if (arg1 < this.iCutover) {
                return this.iJulianField.getDifferenceAsLong(arg0, arg1);
            }
            arg0 = this.julianToGregorian(arg0);
            return this.iGregorianField.getDifferenceAsLong(arg0, arg1);
        }

        ImpreciseCutoverField(DateTimeField a3, DateTimeField a4, DurationField a5, long a6) {
            a7(a3, a4, a5, a6, false);
            ImpreciseCutoverField a7;
        }

        ImpreciseCutoverField(DateTimeField a3, DateTimeField a4, DurationField a5, long a6, boolean a7) {
            ImpreciseCutoverField a8;
            super(a3, a4, a6, a7);
            if (a5 == null) {
                a5 = new LinkedDurationField(a8.iDurationField, a8);
            }
            a8.iDurationField = a5;
        }

        public int getMaximumValue(long arg0) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(arg0);
            }
            return this.iJulianField.getMaximumValue(arg0);
        }

        public long add(long arg0, long arg1) {
            if (arg0 >= this.iCutover) {
                if ((arg0 = this.iGregorianField.add(arg0, arg1)) < this.iCutover && arg0 + GJChronology.this.iGapDuration < this.iCutover) {
                    if (this.iConvertByWeekyear) {
                        int n = GJChronology.this.iGregorianChronology.weekyear().get(arg0);
                        if (n <= 0) {
                            arg0 = GJChronology.this.iGregorianChronology.weekyear().add(arg0, -1);
                        }
                    } else {
                        int n = GJChronology.this.iGregorianChronology.year().get(arg0);
                        if (n <= 0) {
                            arg0 = GJChronology.this.iGregorianChronology.year().add(arg0, -1);
                        }
                    }
                    arg0 = this.gregorianToJulian(arg0);
                }
            } else if ((arg0 = this.iJulianField.add(arg0, arg1)) >= this.iCutover && arg0 - GJChronology.this.iGapDuration >= this.iCutover) {
                arg0 = this.julianToGregorian(arg0);
            }
            return arg0;
        }

        public int getDifference(long arg0, long arg1) {
            if (arg0 >= this.iCutover) {
                if (arg1 >= this.iCutover) {
                    return this.iGregorianField.getDifference(arg0, arg1);
                }
                arg0 = this.gregorianToJulian(arg0);
                return this.iJulianField.getDifference(arg0, arg1);
            }
            if (arg1 < this.iCutover) {
                return this.iJulianField.getDifference(arg0, arg1);
            }
            arg0 = this.julianToGregorian(arg0);
            return this.iGregorianField.getDifference(arg0, arg1);
        }
    }

    private class CutoverField
    extends BaseDateTimeField {
        protected DurationField iRangeDurationField;
        final DateTimeField iGregorianField;
        final DateTimeField iJulianField;
        final long iCutover;
        final boolean iConvertByWeekyear;
        private static final long serialVersionUID = 3528501219481026402L;
        protected DurationField iDurationField;

        public int get(long arg0) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.get(arg0);
            }
            return this.iJulianField.get(arg0);
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            return this.iGregorianField.getDifferenceAsLong(arg0, arg1);
        }

        public long add(long arg0, long arg1) {
            return this.iGregorianField.add(arg0, arg1);
        }

        public String getAsText(long arg0, Locale arg1) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.getAsText(arg0, arg1);
            }
            return this.iJulianField.getAsText(arg0, arg1);
        }

        public long roundFloor(long arg0) {
            if (arg0 >= this.iCutover) {
                if ((arg0 = this.iGregorianField.roundFloor(arg0)) < this.iCutover && arg0 + GJChronology.this.iGapDuration < this.iCutover) {
                    arg0 = this.gregorianToJulian(arg0);
                }
            } else {
                arg0 = this.iJulianField.roundFloor(arg0);
            }
            return arg0;
        }

        CutoverField(DateTimeField a3, DateTimeField a4, long a5, boolean a6) {
            a7(a3, a4, null, a5, a6);
            CutoverField a7;
        }

        public long set(long arg0, int arg1) {
            if (arg0 >= this.iCutover) {
                if ((arg0 = this.iGregorianField.set(arg0, arg1)) < this.iCutover) {
                    if (arg0 + GJChronology.this.iGapDuration < this.iCutover) {
                        arg0 = this.gregorianToJulian(arg0);
                    }
                    if (this.get(arg0) != arg1) {
                        throw new IllegalFieldValueException(this.iGregorianField.getType(), (Number)arg1, null, null);
                    }
                }
            } else if ((arg0 = this.iJulianField.set(arg0, arg1)) >= this.iCutover) {
                if (arg0 - GJChronology.this.iGapDuration >= this.iCutover) {
                    arg0 = this.julianToGregorian(arg0);
                }
                if (this.get(arg0) != arg1) {
                    throw new IllegalFieldValueException(this.iJulianField.getType(), (Number)arg1, null, null);
                }
            }
            return arg0;
        }

        public boolean isLeap(long arg0) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.isLeap(arg0);
            }
            return this.iJulianField.isLeap(arg0);
        }

        public int getMaximumValue(long arg0) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(arg0);
            }
            int n = this.iJulianField.getMaximumValue(arg0);
            if ((arg0 = this.iJulianField.set(arg0, n)) >= this.iCutover) {
                n = this.iJulianField.get(this.iJulianField.add(this.iCutover, -1));
            }
            return n;
        }

        public int[] add(ReadablePartial arg0, int arg1, int[] arg2, int arg3) {
            if (arg3 == 0) {
                return arg2;
            }
            if (DateTimeUtils.isContiguous(arg0)) {
                long l2 = 0L;
                int n = arg0.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    l2 = arg0.getFieldType(i2).getField(GJChronology.this).set(l2, arg2[i2]);
                }
                l2 = this.add(l2, arg3);
                return GJChronology.this.get(arg0, l2);
            }
            return super.add(arg0, arg1, arg2, arg3);
        }

        public long roundCeiling(long arg0) {
            if (arg0 >= this.iCutover) {
                arg0 = this.iGregorianField.roundCeiling(arg0);
            } else if ((arg0 = this.iJulianField.roundCeiling(arg0)) >= this.iCutover && arg0 - GJChronology.this.iGapDuration >= this.iCutover) {
                arg0 = this.julianToGregorian(arg0);
            }
            return arg0;
        }

        public int getDifference(long arg0, long arg1) {
            return this.iGregorianField.getDifference(arg0, arg1);
        }

        public int getMaximumShortTextLength(Locale arg0) {
            return Math.max(this.iJulianField.getMaximumShortTextLength(arg0), this.iGregorianField.getMaximumShortTextLength(arg0));
        }

        public int getMinimumValue(ReadablePartial arg0) {
            return this.iJulianField.getMinimumValue(arg0);
        }

        public int getMaximumValue(ReadablePartial arg0, int[] arg1) {
            GJChronology gJChronology = GJChronology.getInstanceUTC();
            long l2 = 0L;
            int n = arg0.size();
            for (int i2 = 0; i2 < n; ++i2) {
                DateTimeField dateTimeField = arg0.getFieldType(i2).getField(gJChronology);
                if (arg1[i2] > dateTimeField.getMaximumValue(l2)) continue;
                l2 = dateTimeField.set(l2, arg1[i2]);
            }
            return this.getMaximumValue(l2);
        }

        public boolean isLenient() {
            return false;
        }

        public int getMaximumValue(ReadablePartial arg0) {
            long l2 = GJChronology.getInstanceUTC().set(arg0, 0L);
            return this.getMaximumValue(l2);
        }

        public long set(long arg0, String arg1, Locale arg2) {
            if (arg0 >= this.iCutover) {
                if ((arg0 = this.iGregorianField.set(arg0, arg1, arg2)) < this.iCutover && arg0 + GJChronology.this.iGapDuration < this.iCutover) {
                    arg0 = this.gregorianToJulian(arg0);
                }
            } else if ((arg0 = this.iJulianField.set(arg0, arg1, arg2)) >= this.iCutover && arg0 - GJChronology.this.iGapDuration >= this.iCutover) {
                arg0 = this.julianToGregorian(arg0);
            }
            return arg0;
        }

        protected long gregorianToJulian(long arg0) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.gregorianToJulianByWeekyear(arg0);
            }
            return GJChronology.this.gregorianToJulianByYear(arg0);
        }

        protected long julianToGregorian(long arg0) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.julianToGregorianByWeekyear(arg0);
            }
            return GJChronology.this.julianToGregorianByYear(arg0);
        }

        CutoverField(DateTimeField a3, DateTimeField a4, DurationField a5, long a6, boolean a7) {
            CutoverField a8;
            super(a4.getType());
            a8.iJulianField = a3;
            a8.iGregorianField = a4;
            a8.iCutover = a6;
            a8.iConvertByWeekyear = a7;
            a8.iDurationField = a4.getDurationField();
            if (a5 == null && (a5 = a4.getRangeDurationField()) == null) {
                a5 = a3.getRangeDurationField();
            }
            a8.iRangeDurationField = a5;
        }

        public int getMaximumTextLength(Locale arg0) {
            return Math.max(this.iJulianField.getMaximumTextLength(arg0), this.iGregorianField.getMaximumTextLength(arg0));
        }

        public int getLeapAmount(long arg0) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.getLeapAmount(arg0);
            }
            return this.iJulianField.getLeapAmount(arg0);
        }

        CutoverField(DateTimeField a3, DateTimeField a4, long a5) {
            a6(a3, a4, a5, false);
            CutoverField a6;
        }

        public String getAsShortText(int arg0, Locale arg1) {
            return this.iGregorianField.getAsShortText(arg0, arg1);
        }

        public DurationField getDurationField() {
            return this.iDurationField;
        }

        public long add(long arg0, int arg1) {
            return this.iGregorianField.add(arg0, arg1);
        }

        public int getMinimumValue(long arg0) {
            if (arg0 < this.iCutover) {
                return this.iJulianField.getMinimumValue(arg0);
            }
            int n = this.iGregorianField.getMinimumValue(arg0);
            if ((arg0 = this.iGregorianField.set(arg0, n)) < this.iCutover) {
                n = this.iGregorianField.get(this.iCutover);
            }
            return n;
        }

        public String getAsText(int arg0, Locale arg1) {
            return this.iGregorianField.getAsText(arg0, arg1);
        }

        public DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public DurationField getLeapDurationField() {
            return this.iGregorianField.getLeapDurationField();
        }

        public String getAsShortText(long arg0, Locale arg1) {
            if (arg0 >= this.iCutover) {
                return this.iGregorianField.getAsShortText(arg0, arg1);
            }
            return this.iJulianField.getAsShortText(arg0, arg1);
        }

        public int getMinimumValue() {
            return this.iJulianField.getMinimumValue();
        }

        public int getMaximumValue() {
            return this.iGregorianField.getMaximumValue();
        }

        public int getMinimumValue(ReadablePartial arg0, int[] arg1) {
            return this.iJulianField.getMinimumValue(arg0, arg1);
        }
    }
}

