/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicFixedMonthChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class CopticChronology
extends BasicFixedMonthChronology {
    private static final ConcurrentHashMap<DateTimeZone, CopticChronology[]> cCache;
    public static final int AM = 1;
    private static final int MAX_YEAR = 292272708;
    private static final DateTimeField ERA_FIELD;
    private static final long serialVersionUID = -5972804258688333942L;
    private static final int MIN_YEAR = -292269337;
    private static final CopticChronology INSTANCE_UTC;

    public static CopticChronology getInstance() {
        return CopticChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    long getApproxMillisAtEpochDividedByTwo() {
        return 26607895200000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CopticChronology getInstance(DateTimeZone arg0, int arg1) {
        CopticChronology copticChronology;
        CopticChronology[] copticChronologyArray;
        CopticChronology[] copticChronologyArray2;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if ((copticChronologyArray2 = cCache.get(arg0)) == null && (copticChronologyArray = cCache.putIfAbsent(arg0, copticChronologyArray2 = new CopticChronology[7])) != null) {
            copticChronologyArray2 = copticChronologyArray;
        }
        try {
            copticChronology = copticChronologyArray2[arg1 - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid min days in first week: " + arg1);
        }
        if (copticChronology != null) return copticChronology;
        copticChronologyArray = copticChronologyArray2;
        synchronized (copticChronologyArray2) {
            copticChronology = copticChronologyArray2[arg1 - 1];
            if (copticChronology != null) return copticChronology;
            if (arg0 == DateTimeZone.UTC) {
                copticChronology = new CopticChronology(null, null, arg1);
                DateTime dateTime = new DateTime(1, 1, 1, 0, 0, 0, 0, copticChronology);
                copticChronology = new CopticChronology(LimitChronology.getInstance(copticChronology, dateTime, null), null, arg1);
            } else {
                copticChronology = CopticChronology.getInstance(DateTimeZone.UTC, arg1);
                copticChronology = new CopticChronology(ZonedChronology.getInstance(copticChronology, arg0), null, arg1);
            }
            copticChronologyArray2[arg1 - 1] = copticChronology;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return copticChronology;
        }
    }

    public static CopticChronology getInstance(DateTimeZone arg0) {
        return CopticChronology.getInstance(arg0, 4);
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        CopticChronology a2;
        Chronology chronology = a2.getBase();
        int n = a2.getMinimumDaysInFirstWeek();
        n = n == 0 ? 4 : n;
        return chronology == null ? CopticChronology.getInstance(DateTimeZone.UTC, n) : CopticChronology.getInstance(chronology.getZone(), n);
    }

    int getMaxYear() {
        return 292272708;
    }

    static {
        ERA_FIELD = new BasicSingleEraDateTimeField("AM");
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = CopticChronology.getInstance(DateTimeZone.UTC);
    }

    boolean isLeapDay(long a2) {
        CopticChronology a3;
        return a3.dayOfMonth().get(a2) == 6 && a3.monthOfYear().isLeap(a2);
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return CopticChronology.getInstance(arg0);
    }

    public static CopticChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    CopticChronology(Chronology a2, Object a3, int a4) {
        super(a2, a3, a4);
        CopticChronology a5;
    }

    long calculateFirstDayOfYearMillis(int a2) {
        int n;
        int n2 = a2 - 1687;
        if (n2 <= 0) {
            n = n2 + 3 >> 2;
        } else {
            CopticChronology a3;
            n = n2 >> 2;
            if (!a3.isLeapYear(a2)) {
                ++n;
            }
        }
        long l2 = ((long)n2 * 365L + (long)n) * 86400000L;
        return l2 + 21859200000L;
    }

    int getMinYear() {
        return -292269337;
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        if (this.getBase() == null) {
            super.assemble(arg0);
            arg0.year = new SkipDateTimeField(this, arg0.year);
            arg0.weekyear = new SkipDateTimeField(this, arg0.weekyear);
            arg0.era = ERA_FIELD;
            arg0.monthOfYear = new BasicMonthOfYearDateTimeField(this, 13);
            arg0.months = arg0.monthOfYear.getDurationField();
        }
    }
}

