/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

final class BasicWeekyearDateTimeField
extends ImpreciseDateTimeField {
    private static final long WEEK_53 = 31449600000L;
    private static final long serialVersionUID = 6215066916806820644L;
    private final BasicChronology iChronology;

    public long roundFloor(long arg0) {
        arg0 = this.iChronology.weekOfWeekyear().roundFloor(arg0);
        int n = this.iChronology.getWeekOfWeekyear(arg0);
        if (n > 1) {
            arg0 -= 604800000L * (long)(n - 1);
        }
        return arg0;
    }

    public long getDifferenceAsLong(long arg0, long arg1) {
        if (arg0 < arg1) {
            return -this.getDifference(arg1, arg0);
        }
        int n = this.get(arg0);
        int n2 = this.get(arg1);
        long l2 = this.remainder(arg0);
        long l3 = this.remainder(arg1);
        if (l3 >= 31449600000L && this.iChronology.getWeeksInYear(n) <= 52) {
            l3 -= 604800000L;
        }
        int n3 = n - n2;
        if (l2 < l3) {
            --n3;
        }
        return n3;
    }

    public int getLeapAmount(long arg0) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(arg0)) - 52;
    }

    public long add(long arg0, int arg1) {
        if (arg1 == 0) {
            return arg0;
        }
        return this.set(arg0, this.get(arg0) + arg1);
    }

    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    public long add(long arg0, long arg1) {
        return this.add(arg0, FieldUtils.safeToInt(arg1));
    }

    private Object readResolve() {
        BasicWeekyearDateTimeField a2;
        return a2.iChronology.weekyear();
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public long addWrapField(long arg0, int arg1) {
        return this.add(arg0, arg1);
    }

    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    BasicWeekyearDateTimeField(BasicChronology a2) {
        super(DateTimeFieldType.weekyear(), a2.getAverageMillisPerYear());
        BasicWeekyearDateTimeField a3;
        a3.iChronology = a2;
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, Math.abs(arg1), this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        int n = this.get(arg0);
        if (n == arg1) {
            return arg0;
        }
        int n2 = this.iChronology.getDayOfWeek(arg0);
        int n3 = this.iChronology.getWeeksInYear(n);
        int n4 = this.iChronology.getWeeksInYear(arg1);
        int n5 = n4 < n3 ? n4 : n3;
        int n6 = this.iChronology.getWeekOfWeekyear(arg0);
        if (n6 > n5) {
            n6 = n5;
        }
        long l2 = arg0;
        int n7 = this.get(l2 = this.iChronology.setYear(l2, arg1));
        if (n7 < arg1) {
            l2 += 604800000L;
        } else if (n7 > arg1) {
            l2 -= 604800000L;
        }
        int n8 = this.iChronology.getWeekOfWeekyear(l2);
        l2 += (long)(n6 - n8) * 604800000L;
        l2 = this.iChronology.dayOfWeek().set(l2, n2);
        return l2;
    }

    public long remainder(long arg0) {
        return arg0 - this.roundFloor(arg0);
    }

    public int get(long arg0) {
        return this.iChronology.getWeekyear(arg0);
    }

    public boolean isLeap(long arg0) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(arg0)) > 52;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.weeks();
    }

    public boolean isLenient() {
        return false;
    }
}

