/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicWeekOfWeekyearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -1587436826395135328L;
    private final BasicChronology iChronology;

    public long roundFloor(long arg0) {
        return super.roundFloor(arg0 + 259200000L) - 259200000L;
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue(long arg0) {
        int n = this.iChronology.getWeekyear(arg0);
        return this.iChronology.getWeeksInYear(n);
    }

    BasicWeekOfWeekyearDateTimeField(BasicChronology a2, DurationField a3) {
        super(DateTimeFieldType.weekOfWeekyear(), a3);
        BasicWeekOfWeekyearDateTimeField a4;
        a4.iChronology = a2;
    }

    public int get(long arg0) {
        return this.iChronology.getWeekOfWeekyear(arg0);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.weekyears();
    }

    protected int getMaximumValueForSet(long arg0, int arg1) {
        return arg1 > 52 ? this.getMaximumValue(arg0) : 52;
    }

    public long roundCeiling(long arg0) {
        return super.roundCeiling(arg0 + 259200000L) - 259200000L;
    }

    public int getMaximumValue() {
        return 53;
    }

    public int getMaximumValue(ReadablePartial arg0, int[] arg1) {
        int n = arg0.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (arg0.getFieldType(i2) != DateTimeFieldType.weekyear()) continue;
            int n2 = arg1[i2];
            return this.iChronology.getWeeksInYear(n2);
        }
        return 53;
    }

    public int getMaximumValue(ReadablePartial arg0) {
        if (arg0.isSupported(DateTimeFieldType.weekyear())) {
            int n = arg0.get(DateTimeFieldType.weekyear());
            return this.iChronology.getWeeksInYear(n);
        }
        return 53;
    }

    private Object readResolve() {
        BasicWeekOfWeekyearDateTimeField a2;
        return a2.iChronology.weekOfWeekyear();
    }

    public long remainder(long arg0) {
        return super.remainder(arg0 + 259200000L);
    }
}

