/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -6821236822336841037L;
    private final BasicChronology iChronology;

    public int get(long arg0) {
        return this.iChronology.getDayOfYear(arg0);
    }

    BasicDayOfYearDateTimeField(BasicChronology a2, DurationField a3) {
        super(DateTimeFieldType.dayOfYear(), a3);
        BasicDayOfYearDateTimeField a4;
        a4.iChronology = a2;
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue(ReadablePartial arg0, int[] arg1) {
        int n = arg0.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (arg0.getFieldType(i2) != DateTimeFieldType.year()) continue;
            int n2 = arg1[i2];
            return this.iChronology.getDaysInYear(n2);
        }
        return this.iChronology.getDaysInYearMax();
    }

    public int getMaximumValue(long arg0) {
        int n = this.iChronology.getYear(arg0);
        return this.iChronology.getDaysInYear(n);
    }

    private Object readResolve() {
        BasicDayOfYearDateTimeField a2;
        return a2.iChronology.dayOfYear();
    }

    public boolean isLeap(long arg0) {
        return this.iChronology.isLeapDay(arg0);
    }

    public int getMaximumValue(ReadablePartial arg0) {
        if (arg0.isSupported(DateTimeFieldType.year())) {
            int n = arg0.get(DateTimeFieldType.year());
            return this.iChronology.getDaysInYear(n);
        }
        return this.iChronology.getDaysInYearMax();
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public int getMaximumValue() {
        return this.iChronology.getDaysInYearMax();
    }

    protected int getMaximumValueForSet(long arg0, int arg1) {
        int n = this.iChronology.getDaysInYearMax() - 1;
        return arg1 > n || arg1 < 1 ? this.getMaximumValue(arg0) : n;
    }
}

