/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSingleFieldPeriod
implements ReadablePeriod,
Comparable<BaseSingleFieldPeriod>,
Serializable {
    private volatile int iPeriod;
    private static final long START_1972 = 63072000000L;
    private static final long serialVersionUID = 9386874258972L;

    @Override
    public MutablePeriod toMutablePeriod() {
        MutablePeriod mutablePeriod = new MutablePeriod();
        mutablePeriod.add(this);
        return mutablePeriod;
    }

    protected BaseSingleFieldPeriod(int arg0) {
        this.iPeriod = arg0;
    }

    @Override
    public boolean isSupported(DurationFieldType arg0) {
        return arg0 == this.getFieldType();
    }

    @Override
    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod readablePeriod = (ReadablePeriod)arg0;
        return readablePeriod.getPeriodType() == this.getPeriodType() && readablePeriod.getValue(0) == this.getValue();
    }

    protected static int standardPeriodIn(ReadablePeriod arg0, long arg1) {
        if (arg0 == null) {
            return 0;
        }
        ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
        long l2 = 0L;
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            int n = arg0.getValue(i2);
            if (n == 0) continue;
            DurationField durationField = arg0.getFieldType(i2).getField(iSOChronology);
            if (!durationField.isPrecise()) {
                throw new IllegalArgumentException("Cannot convert period to duration as " + durationField.getName() + " is not precise in the period " + arg0);
            }
            l2 = FieldUtils.safeAdd(l2, FieldUtils.safeMultiply(durationField.getUnitMillis(), n));
        }
        return FieldUtils.safeToInt(l2 / arg1);
    }

    @Override
    public int size() {
        return 1;
    }

    protected void setValue(int arg0) {
        this.iPeriod = arg0;
    }

    protected static int between(ReadablePartial arg0, ReadablePartial arg1, ReadablePeriod arg2) {
        if (arg0 == null || arg1 == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (arg0.size() != arg1.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        int n = arg0.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (arg0.getFieldType(i2) == arg1.getFieldType(i2)) continue;
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        if (!DateTimeUtils.isContiguous(arg0)) {
            throw new IllegalArgumentException("ReadablePartial objects must be contiguous");
        }
        Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology()).withUTC();
        int[] nArray = chronology.get(arg2, chronology.set(arg0, 63072000000L), chronology.set(arg1, 63072000000L));
        return nArray[0];
    }

    @Override
    public DurationFieldType getFieldType(int arg0) {
        if (arg0 != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(arg0));
        }
        return this.getFieldType();
    }

    @Override
    public Period toPeriod() {
        return Period.ZERO.withFields(this);
    }

    public abstract DurationFieldType getFieldType();

    @Override
    public abstract PeriodType getPeriodType();

    @Override
    public int compareTo(BaseSingleFieldPeriod arg0) {
        if (arg0.getClass() != this.getClass()) {
            throw new ClassCastException(this.getClass() + " cannot be compared to " + arg0.getClass());
        }
        int n = arg0.getValue();
        int n2 = this.getValue();
        if (n2 > n) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        return 0;
    }

    protected int getValue() {
        return this.iPeriod;
    }

    protected static int between(ReadableInstant arg0, ReadableInstant arg1, DurationFieldType arg2) {
        if (arg0 == null || arg1 == null) {
            throw new IllegalArgumentException("ReadableInstant objects must not be null");
        }
        Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
        int n = arg2.getField(chronology).getDifference(arg1.getMillis(), arg0.getMillis());
        return n;
    }

    @Override
    public int getValue(int arg0) {
        if (arg0 != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(arg0));
        }
        return this.getValue();
    }

    @Override
    public int get(DurationFieldType arg0) {
        if (arg0 == this.getFieldType()) {
            return this.getValue();
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 27 * n + this.getValue();
        n = 27 * n + this.getFieldType().hashCode();
        return n;
    }
}

