/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.MutableInterval;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractInterval;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.field.FieldUtils;

public abstract class BaseInterval
extends AbstractInterval
implements ReadableInterval,
Serializable {
    private volatile Chronology iChronology;
    private volatile long iEndMillis;
    private volatile long iStartMillis;
    private static final long serialVersionUID = 576586928732749278L;

    protected BaseInterval(ReadablePeriod arg0, ReadableInstant arg1) {
        Chronology chronology;
        this.iChronology = chronology = DateTimeUtils.getInstantChronology(arg1);
        this.iEndMillis = DateTimeUtils.getInstantMillis(arg1);
        this.iStartMillis = arg0 == null ? this.iEndMillis : chronology.add(arg0, this.iEndMillis, -1);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    public long getStartMillis() {
        return this.iStartMillis;
    }

    protected void setInterval(long arg0, long arg1, Chronology arg2) {
        this.checkInterval(arg0, arg1);
        this.iStartMillis = arg0;
        this.iEndMillis = arg1;
        this.iChronology = DateTimeUtils.getChronology(arg2);
    }

    protected BaseInterval(ReadableInstant arg0, ReadableInstant arg1) {
        if (arg0 == null && arg1 == null) {
            this.iStartMillis = this.iEndMillis = DateTimeUtils.currentTimeMillis();
            this.iChronology = ISOChronology.getInstance();
        } else {
            this.iChronology = DateTimeUtils.getInstantChronology(arg0);
            this.iStartMillis = DateTimeUtils.getInstantMillis(arg0);
            this.iEndMillis = DateTimeUtils.getInstantMillis(arg1);
            this.checkInterval(this.iStartMillis, this.iEndMillis);
        }
    }

    protected BaseInterval(long arg0, long arg1, Chronology arg2) {
        this.iChronology = DateTimeUtils.getChronology(arg2);
        this.checkInterval(arg0, arg1);
        this.iStartMillis = arg0;
        this.iEndMillis = arg1;
    }

    public long getEndMillis() {
        return this.iEndMillis;
    }

    protected BaseInterval(ReadableInstant arg0, ReadableDuration arg1) {
        this.iChronology = DateTimeUtils.getInstantChronology(arg0);
        this.iStartMillis = DateTimeUtils.getInstantMillis(arg0);
        long l2 = DateTimeUtils.getDurationMillis(arg1);
        this.iEndMillis = FieldUtils.safeAdd(this.iStartMillis, l2);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadableDuration arg0, ReadableInstant arg1) {
        this.iChronology = DateTimeUtils.getInstantChronology(arg1);
        this.iEndMillis = DateTimeUtils.getInstantMillis(arg1);
        long l2 = DateTimeUtils.getDurationMillis(arg0);
        this.iStartMillis = FieldUtils.safeAdd(this.iEndMillis, -l2);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadableInstant arg0, ReadablePeriod arg1) {
        Chronology chronology;
        this.iChronology = chronology = DateTimeUtils.getInstantChronology(arg0);
        this.iStartMillis = DateTimeUtils.getInstantMillis(arg0);
        this.iEndMillis = arg1 == null ? this.iStartMillis : chronology.add(arg1, this.iStartMillis, 1);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected BaseInterval(Object arg0, Chronology arg1) {
        IntervalConverter intervalConverter = ConverterManager.getInstance().getIntervalConverter(arg0);
        if (intervalConverter.isReadableInterval(arg0, arg1)) {
            ReadableInterval readableInterval = (ReadableInterval)arg0;
            this.iChronology = arg1 != null ? arg1 : readableInterval.getChronology();
            this.iStartMillis = readableInterval.getStartMillis();
            this.iEndMillis = readableInterval.getEndMillis();
        } else if (this instanceof ReadWritableInterval) {
            intervalConverter.setInto((ReadWritableInterval)((Object)this), arg0, arg1);
        } else {
            MutableInterval mutableInterval = new MutableInterval();
            intervalConverter.setInto(mutableInterval, arg0, arg1);
            this.iChronology = mutableInterval.getChronology();
            this.iStartMillis = mutableInterval.getStartMillis();
            this.iEndMillis = mutableInterval.getEndMillis();
        }
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }
}

