/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;

public class PeriodType
implements Serializable {
    private static PeriodType cDTime;
    private static PeriodType cYWDTime;
    private static PeriodType cYD;
    private static PeriodType cYMD;
    private static PeriodType cYWD;
    private static PeriodType cStandard;
    private static final Map<PeriodType, Object> cTypes;
    private static PeriodType cMillis;
    static int MINUTE_INDEX;
    private static PeriodType cWeeks;
    private final int[] iIndices;
    private static PeriodType cMonths;
    static int SECOND_INDEX;
    static int MILLI_INDEX;
    static int HOUR_INDEX;
    static int WEEK_INDEX;
    private final DurationFieldType[] iTypes;
    private static PeriodType cMinutes;
    private static PeriodType cYMDTime;
    private static PeriodType cHours;
    private static PeriodType cYears;
    static int YEAR_INDEX;
    private static PeriodType cTime;
    private static final long serialVersionUID = 2274324892792009998L;
    private static PeriodType cDays;
    static int DAY_INDEX;
    private static PeriodType cYDTime;
    private final String iName;
    private static PeriodType cSeconds;
    static int MONTH_INDEX;

    public int indexOf(DurationFieldType arg0) {
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.iTypes[i2] != arg0) continue;
            return i2;
        }
        return -1;
    }

    public static PeriodType dayTime() {
        PeriodType periodType = cDTime;
        if (periodType == null) {
            cDTime = periodType = new PeriodType("DayTime", new DurationFieldType[]{DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, 0, 1, 2, 3, 4});
        }
        return periodType;
    }

    public static PeriodType yearMonthDay() {
        PeriodType periodType = cYMD;
        if (periodType == null) {
            cYMD = periodType = new PeriodType("YearMonthDay", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.days()}, new int[]{0, 1, -1, 2, -1, -1, -1, -1});
        }
        return periodType;
    }

    public PeriodType withHoursRemoved() {
        return this.withFieldRemoved(4, "NoHours");
    }

    public PeriodType withWeeksRemoved() {
        return this.withFieldRemoved(2, "NoWeeks");
    }

    public static PeriodType days() {
        PeriodType periodType = cDays;
        if (periodType == null) {
            cDays = periodType = new PeriodType("Days", new DurationFieldType[]{DurationFieldType.days()}, new int[]{-1, -1, -1, 0, -1, -1, -1, -1});
        }
        return periodType;
    }

    public static PeriodType weeks() {
        PeriodType periodType = cWeeks;
        if (periodType == null) {
            cWeeks = periodType = new PeriodType("Weeks", new DurationFieldType[]{DurationFieldType.weeks()}, new int[]{-1, -1, 0, -1, -1, -1, -1, -1});
        }
        return periodType;
    }

    public int size() {
        return this.iTypes.length;
    }

    public static PeriodType yearDay() {
        PeriodType periodType = cYD;
        if (periodType == null) {
            cYD = periodType = new PeriodType("YearDay", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.days()}, new int[]{0, -1, -1, 1, -1, -1, -1, -1});
        }
        return periodType;
    }

    public PeriodType withMillisRemoved() {
        return this.withFieldRemoved(7, "NoMillis");
    }

    public DurationFieldType getFieldType(int arg0) {
        return this.iTypes[arg0];
    }

    protected PeriodType(String arg0, DurationFieldType[] arg1, int[] arg2) {
        this.iName = arg0;
        this.iTypes = arg1;
        this.iIndices = arg2;
    }

    public static PeriodType months() {
        PeriodType periodType = cMonths;
        if (periodType == null) {
            cMonths = periodType = new PeriodType("Months", new DurationFieldType[]{DurationFieldType.months()}, new int[]{-1, 0, -1, -1, -1, -1, -1, -1});
        }
        return periodType;
    }

    public static PeriodType time() {
        PeriodType periodType = cTime;
        if (periodType == null) {
            cTime = periodType = new PeriodType("Time", new DurationFieldType[]{DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, 0, 1, 2, 3});
        }
        return periodType;
    }

    public static PeriodType yearWeekDay() {
        PeriodType periodType = cYWD;
        if (periodType == null) {
            cYWD = periodType = new PeriodType("YearWeekDay", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.weeks(), DurationFieldType.days()}, new int[]{0, -1, 1, 2, -1, -1, -1, -1});
        }
        return periodType;
    }

    private PeriodType withFieldRemoved(int a2, String a3) {
        PeriodType a4;
        int n = a4.iIndices[a2];
        if (n == -1) {
            return a4;
        }
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[a4.size() - 1];
        for (int i2 = 0; i2 < a4.iTypes.length; ++i2) {
            if (i2 < n) {
                durationFieldTypeArray[i2] = a4.iTypes[i2];
                continue;
            }
            if (i2 <= n) continue;
            durationFieldTypeArray[i2 - 1] = a4.iTypes[i2];
        }
        int[] nArray = new int[8];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            nArray[i3] = i3 < a2 ? a4.iIndices[i3] : (i3 > a2 ? (a4.iIndices[i3] == -1 ? -1 : a4.iIndices[i3] - 1) : -1);
        }
        return new PeriodType(a4.getName() + a3, durationFieldTypeArray, nArray);
    }

    public static PeriodType yearMonthDayTime() {
        PeriodType periodType = cYMDTime;
        if (periodType == null) {
            cYMDTime = periodType = new PeriodType("YearMonthDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, -1, 2, 3, 4, 5, 6});
        }
        return periodType;
    }

    public PeriodType withYearsRemoved() {
        return this.withFieldRemoved(0, "NoYears");
    }

    public static PeriodType millis() {
        PeriodType periodType = cMillis;
        if (periodType == null) {
            cMillis = periodType = new PeriodType("Millis", new DurationFieldType[]{DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, -1, -1, -1, 0});
        }
        return periodType;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof PeriodType)) {
            return false;
        }
        PeriodType periodType = (PeriodType)arg0;
        return Arrays.equals(this.iTypes, periodType.iTypes);
    }

    public PeriodType withSecondsRemoved() {
        return this.withFieldRemoved(6, "NoSeconds");
    }

    public PeriodType withMinutesRemoved() {
        return this.withFieldRemoved(5, "NoMinutes");
    }

    static {
        cTypes = new HashMap<PeriodType, Object>(32);
        YEAR_INDEX = 0;
        MONTH_INDEX = 1;
        WEEK_INDEX = 2;
        DAY_INDEX = 3;
        HOUR_INDEX = 4;
        MINUTE_INDEX = 5;
        SECOND_INDEX = 6;
        MILLI_INDEX = 7;
    }

    public static PeriodType years() {
        PeriodType periodType = cYears;
        if (periodType == null) {
            cYears = periodType = new PeriodType("Years", new DurationFieldType[]{DurationFieldType.years()}, new int[]{0, -1, -1, -1, -1, -1, -1, -1});
        }
        return periodType;
    }

    boolean addIndexedField(ReadablePeriod a2, int a3, int[] a4, int a5) {
        PeriodType a6;
        if (a5 == 0) {
            return false;
        }
        int n = a6.iIndices[a3];
        if (n == -1) {
            throw new UnsupportedOperationException("Field is not supported");
        }
        a4[n] = FieldUtils.safeAdd(a4[n], a5);
        return true;
    }

    public static PeriodType yearDayTime() {
        PeriodType periodType = cYDTime;
        if (periodType == null) {
            cYDTime = periodType = new PeriodType("YearDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, -1, -1, 1, 2, 3, 4, 5});
        }
        return periodType;
    }

    public static synchronized PeriodType forFields(DurationFieldType[] arg0) {
        PeriodType periodType;
        Object object;
        if (arg0 == null || arg0.length == 0) {
            throw new IllegalArgumentException("Types array must not be null or empty");
        }
        for (int i2 = 0; i2 < arg0.length; ++i2) {
            if (arg0[i2] != null) continue;
            throw new IllegalArgumentException("Types array must not contain null");
        }
        Map<PeriodType, Object> map = cTypes;
        if (map.isEmpty()) {
            map.put(PeriodType.standard(), PeriodType.standard());
            map.put(PeriodType.yearMonthDayTime(), PeriodType.yearMonthDayTime());
            map.put(PeriodType.yearMonthDay(), PeriodType.yearMonthDay());
            map.put(PeriodType.yearWeekDayTime(), PeriodType.yearWeekDayTime());
            map.put(PeriodType.yearWeekDay(), PeriodType.yearWeekDay());
            map.put(PeriodType.yearDayTime(), PeriodType.yearDayTime());
            map.put(PeriodType.yearDay(), PeriodType.yearDay());
            map.put(PeriodType.dayTime(), PeriodType.dayTime());
            map.put(PeriodType.time(), PeriodType.time());
            map.put(PeriodType.years(), PeriodType.years());
            map.put(PeriodType.months(), PeriodType.months());
            map.put(PeriodType.weeks(), PeriodType.weeks());
            map.put(PeriodType.days(), PeriodType.days());
            map.put(PeriodType.hours(), PeriodType.hours());
            map.put(PeriodType.minutes(), PeriodType.minutes());
            map.put(PeriodType.seconds(), PeriodType.seconds());
            map.put(PeriodType.millis(), PeriodType.millis());
        }
        if ((object = map.get(periodType = new PeriodType(null, arg0, null))) instanceof PeriodType) {
            return (PeriodType)object;
        }
        if (object != null) {
            throw new IllegalArgumentException("PeriodType does not support fields: " + object);
        }
        PeriodType periodType2 = PeriodType.standard();
        ArrayList<DurationFieldType> arrayList = new ArrayList<DurationFieldType>(Arrays.asList(arg0));
        if (!arrayList.remove(DurationFieldType.years())) {
            periodType2 = periodType2.withYearsRemoved();
        }
        if (!arrayList.remove(DurationFieldType.months())) {
            periodType2 = periodType2.withMonthsRemoved();
        }
        if (!arrayList.remove(DurationFieldType.weeks())) {
            periodType2 = periodType2.withWeeksRemoved();
        }
        if (!arrayList.remove(DurationFieldType.days())) {
            periodType2 = periodType2.withDaysRemoved();
        }
        if (!arrayList.remove(DurationFieldType.hours())) {
            periodType2 = periodType2.withHoursRemoved();
        }
        if (!arrayList.remove(DurationFieldType.minutes())) {
            periodType2 = periodType2.withMinutesRemoved();
        }
        if (!arrayList.remove(DurationFieldType.seconds())) {
            periodType2 = periodType2.withSecondsRemoved();
        }
        if (!arrayList.remove(DurationFieldType.millis())) {
            periodType2 = periodType2.withMillisRemoved();
        }
        if (arrayList.size() > 0) {
            map.put(periodType, arrayList);
            throw new IllegalArgumentException("PeriodType does not support fields: " + arrayList);
        }
        PeriodType periodType3 = new PeriodType(null, periodType2.iTypes, null);
        PeriodType periodType4 = (PeriodType)map.get(periodType3);
        if (periodType4 != null) {
            map.put(periodType3, periodType4);
            return periodType4;
        }
        map.put(periodType3, periodType2);
        return periodType2;
    }

    public PeriodType withMonthsRemoved() {
        return this.withFieldRemoved(1, "NoMonths");
    }

    public PeriodType withDaysRemoved() {
        return this.withFieldRemoved(3, "NoDays");
    }

    public static PeriodType standard() {
        PeriodType periodType = cStandard;
        if (periodType == null) {
            cStandard = periodType = new PeriodType("Standard", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        }
        return periodType;
    }

    public static PeriodType minutes() {
        PeriodType periodType = cMinutes;
        if (periodType == null) {
            cMinutes = periodType = new PeriodType("Minutes", new DurationFieldType[]{DurationFieldType.minutes()}, new int[]{-1, -1, -1, -1, -1, 0, -1, -1});
        }
        return periodType;
    }

    public static PeriodType hours() {
        PeriodType periodType = cHours;
        if (periodType == null) {
            cHours = periodType = new PeriodType("Hours", new DurationFieldType[]{DurationFieldType.hours()}, new int[]{-1, -1, -1, -1, 0, -1, -1, -1});
        }
        return periodType;
    }

    public String getName() {
        return this.iName;
    }

    public static PeriodType yearWeekDayTime() {
        PeriodType periodType = cYWDTime;
        if (periodType == null) {
            cYWDTime = periodType = new PeriodType("YearWeekDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, -1, 1, 2, 3, 4, 5, 6});
        }
        return periodType;
    }

    public String toString() {
        return "PeriodType[" + this.getName() + "]";
    }

    public static PeriodType seconds() {
        PeriodType periodType = cSeconds;
        if (periodType == null) {
            cSeconds = periodType = new PeriodType("Seconds", new DurationFieldType[]{DurationFieldType.seconds()}, new int[]{-1, -1, -1, -1, -1, -1, 0, -1});
        }
        return periodType;
    }

    public int hashCode() {
        int n = 0;
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            n += this.iTypes[i2].hashCode();
        }
        return n;
    }

    public boolean isSupported(DurationFieldType arg0) {
        return this.indexOf(arg0) >= 0;
    }

    int getIndexedField(ReadablePeriod a2, int a3) {
        PeriodType a4;
        int n = a4.iIndices[a3];
        return n == -1 ? 0 : a2.getValue(n);
    }

    boolean setIndexedField(ReadablePeriod a2, int a3, int[] a4, int a5) {
        PeriodType a6;
        int n = a6.iIndices[a3];
        if (n == -1) {
            throw new UnsupportedOperationException("Field is not supported");
        }
        a4[n] = a5;
        return true;
    }
}

