/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPartial;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Partial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private final int[] iValues;
    private final DateTimeFieldType[] iTypes;
    private final Chronology iChronology;
    private static final long serialVersionUID = 12324121189002L;
    private transient DateTimeFormatter[] iFormatter;

    public Partial() {
        this((Chronology)null);
    }

    public Partial with(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        int n = this.indexOf(arg0);
        if (n == -1) {
            Serializable serializable;
            int n2;
            DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[this.iTypes.length + 1];
            int[] nArray = new int[dateTimeFieldTypeArray.length];
            DurationField durationField = arg0.getDurationType().getField(this.iChronology);
            if (durationField.isSupported()) {
                DurationField durationField2;
                DurationField durationField3;
                int n3;
                DurationField durationField4;
                for (n2 = 0; !(n2 >= this.iTypes.length || (durationField4 = (serializable = this.iTypes[n2]).getDurationType().getField(this.iChronology)).isSupported() && ((n3 = durationField.compareTo(durationField4)) > 0 || n3 == 0 && (arg0.getRangeDurationType() == null || serializable.getRangeDurationType() != null && (durationField3 = arg0.getRangeDurationType().getField(this.iChronology)).compareTo(durationField2 = serializable.getRangeDurationType().getField(this.iChronology)) > 0))); ++n2) {
                }
            }
            System.arraycopy(this.iTypes, 0, dateTimeFieldTypeArray, 0, n2);
            System.arraycopy(this.iValues, 0, nArray, 0, n2);
            dateTimeFieldTypeArray[n2] = arg0;
            nArray[n2] = arg1;
            System.arraycopy(this.iTypes, n2, dateTimeFieldTypeArray, n2 + 1, dateTimeFieldTypeArray.length - n2 - 1);
            System.arraycopy(this.iValues, n2, nArray, n2 + 1, nArray.length - n2 - 1);
            serializable = new Partial(dateTimeFieldTypeArray, nArray, this.iChronology);
            this.iChronology.validate((ReadablePartial)((Object)serializable), nArray);
            return serializable;
        }
        if (arg1 == this.getValue(n)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).set(this, n, nArray, arg1);
        return new Partial(this, nArray);
    }

    public Partial(DateTimeFieldType arg0, int arg1, Chronology arg2) {
        this.iChronology = arg2 = DateTimeUtils.getChronology(arg2).withUTC();
        if (arg0 == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        this.iTypes = new DateTimeFieldType[]{arg0};
        this.iValues = new int[]{arg1};
        arg2.validate(this, this.iValues);
    }

    public Partial without(DateTimeFieldType arg0) {
        int n = this.indexOf(arg0);
        if (n != -1) {
            DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[this.size() - 1];
            int[] nArray = new int[this.size() - 1];
            System.arraycopy(this.iTypes, 0, dateTimeFieldTypeArray, 0, n);
            System.arraycopy(this.iTypes, n + 1, dateTimeFieldTypeArray, n, dateTimeFieldTypeArray.length - n);
            System.arraycopy(this.iValues, 0, nArray, 0, n);
            System.arraycopy(this.iValues, n + 1, nArray, n, nArray.length - n);
            Partial partial = new Partial(this.iChronology, dateTimeFieldTypeArray, nArray);
            this.iChronology.validate(partial, nArray);
            return partial;
        }
        return this;
    }

    public Partial plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public String toStringList() {
        int n = this.size();
        StringBuilder stringBuilder = new StringBuilder(20 * n);
        stringBuilder.append('[');
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(this.iTypes[i2].getName());
            stringBuilder.append('=');
            stringBuilder.append(this.iValues[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public boolean isMatch(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            int n = this.iTypes[i2].getField(chronology).get(l2);
            if (n == this.iValues[i2]) continue;
            return false;
        }
        return true;
    }

    public DateTimeFieldType getFieldType(int arg0) {
        return this.iTypes[arg0];
    }

    public String toString() {
        DateTimeFormatter dateTimeFormatter;
        DateTimeFormatter[] dateTimeFormatterArray = this.iFormatter;
        if (dateTimeFormatterArray == null) {
            this.getFormatter();
            dateTimeFormatterArray = this.iFormatter;
            if (dateTimeFormatterArray == null) {
                return this.toStringList();
            }
        }
        if ((dateTimeFormatter = dateTimeFormatterArray[1]) == null) {
            return this.toStringList();
        }
        return dateTimeFormatter.print(this);
    }

    public String toString(String arg0, Locale arg1) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).withLocale(arg1).print(this);
    }

    public Partial(Chronology arg0) {
        this.iChronology = DateTimeUtils.getChronology(arg0).withUTC();
        this.iTypes = new DateTimeFieldType[0];
        this.iValues = new int[0];
    }

    Partial(Partial a2, int[] a3) {
        Partial a4;
        a4.iChronology = a2.iChronology;
        a4.iTypes = a2.iTypes;
        a4.iValues = a3;
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        return this.iTypes[arg0].getField(arg1);
    }

    public Property property(DateTimeFieldType arg0) {
        return new Property(this, this.indexOfSupported(arg0));
    }

    public int getValue(int arg0) {
        return this.iValues[arg0];
    }

    public DateTimeFormatter getFormatter() {
        DateTimeFormatter[] dateTimeFormatterArray = this.iFormatter;
        if (dateTimeFormatterArray == null) {
            if (this.size() == 0) {
                return null;
            }
            dateTimeFormatterArray = new DateTimeFormatter[2];
            try {
                ArrayList<DateTimeFieldType> arrayList = new ArrayList<DateTimeFieldType>(Arrays.asList(this.iTypes));
                dateTimeFormatterArray[0] = ISODateTimeFormat.forFields(arrayList, true, false);
                if (arrayList.size() == 0) {
                    dateTimeFormatterArray[1] = dateTimeFormatterArray[0];
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.iFormatter = dateTimeFormatterArray;
        }
        return dateTimeFormatterArray[0];
    }

    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public Partial(DateTimeFieldType arg0, int arg1) {
        this(arg0, arg1, null);
    }

    public boolean isMatch(ReadablePartial arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            int n = arg0.get(this.iTypes[i2]);
            if (n == this.iValues[i2]) continue;
            return false;
        }
        return true;
    }

    public Partial withFieldAddWrapped(DurationFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).addWrapPartial(this, n, nArray, arg1);
        return new Partial(this, nArray);
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])this.iTypes.clone();
    }

    public Partial withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            DurationFieldType durationFieldType = arg0.getFieldType(i2);
            int n = this.indexOf(durationFieldType);
            if (n < 0) continue;
            nArray = this.getField(n).add(this, n, nArray, FieldUtils.safeMultiply(arg0.getValue(i2), arg1));
        }
        return new Partial(this, nArray);
    }

    Partial(Chronology a2, DateTimeFieldType[] a3, int[] a4) {
        Partial a5;
        a5.iChronology = a2;
        a5.iTypes = a3;
        a5.iValues = a4;
    }

    public Partial(DateTimeFieldType[] arg0, int[] arg1) {
        this(arg0, arg1, null);
    }

    public Partial withField(DateTimeFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == this.getValue(n)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).set(this, n, nArray, arg1);
        return new Partial(this, nArray);
    }

    public Partial(ReadablePartial arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        this.iChronology = DateTimeUtils.getChronology(arg0.getChronology()).withUTC();
        this.iTypes = new DateTimeFieldType[arg0.size()];
        this.iValues = new int[arg0.size()];
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            this.iTypes[i2] = arg0.getFieldType(i2);
            this.iValues[i2] = arg0.getValue(i2);
        }
    }

    public Partial withFieldAdded(DurationFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).add(this, n, nArray, arg1);
        return new Partial(this, nArray);
    }

    public Partial withChronologyRetainFields(Chronology arg0) {
        arg0 = DateTimeUtils.getChronology(arg0);
        if ((arg0 = arg0.withUTC()) == this.getChronology()) {
            return this;
        }
        Partial partial = new Partial(arg0, this.iTypes, this.iValues);
        arg0.validate(partial, this.iValues);
        return partial;
    }

    public int size() {
        return this.iTypes.length;
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    public String toString(String arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).print(this);
    }

    public Partial minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public Partial(DateTimeFieldType[] arg0, int[] arg1, Chronology arg2) {
        this.iChronology = arg2 = DateTimeUtils.getChronology(arg2).withUTC();
        if (arg0 == null) {
            throw new IllegalArgumentException("Types array must not be null");
        }
        if (arg1 == null) {
            throw new IllegalArgumentException("Values array must not be null");
        }
        if (arg1.length != arg0.length) {
            throw new IllegalArgumentException("Values array must be the same length as the types array");
        }
        if (arg0.length == 0) {
            this.iTypes = arg0;
            this.iValues = arg1;
            return;
        }
        for (int i2 = 0; i2 < arg0.length; ++i2) {
            if (arg0[i2] != null) continue;
            throw new IllegalArgumentException("Types array must not contain null: index " + i2);
        }
        DurationField durationField = null;
        for (int i3 = 0; i3 < arg0.length; ++i3) {
            DateTimeFieldType dateTimeFieldType = arg0[i3];
            DurationField durationField2 = dateTimeFieldType.getDurationType().getField(this.iChronology);
            if (i3 > 0) {
                if (!durationField2.isSupported()) {
                    if (durationField.isSupported()) {
                        throw new IllegalArgumentException("Types array must be in order largest-smallest: " + arg0[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                    }
                    throw new IllegalArgumentException("Types array must not contain duplicate unsupported: " + arg0[i3 - 1].getName() + " and " + dateTimeFieldType.getName());
                }
                int n = durationField.compareTo(durationField2);
                if (n < 0) {
                    throw new IllegalArgumentException("Types array must be in order largest-smallest: " + arg0[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                }
                if (n == 0) {
                    if (durationField.equals(durationField2)) {
                        DurationFieldType durationFieldType = arg0[i3 - 1].getRangeDurationType();
                        DurationFieldType durationFieldType2 = dateTimeFieldType.getRangeDurationType();
                        if (durationFieldType == null) {
                            if (durationFieldType2 == null) {
                                throw new IllegalArgumentException("Types array must not contain duplicate: " + arg0[i3 - 1].getName() + " and " + dateTimeFieldType.getName());
                            }
                        } else {
                            DurationField durationField3;
                            if (durationFieldType2 == null) {
                                throw new IllegalArgumentException("Types array must be in order largest-smallest: " + arg0[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                            }
                            DurationField durationField4 = durationFieldType.getField(this.iChronology);
                            if (durationField4.compareTo(durationField3 = durationFieldType2.getField(this.iChronology)) < 0) {
                                throw new IllegalArgumentException("Types array must be in order largest-smallest: " + arg0[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                            }
                            if (durationField4.compareTo(durationField3) == 0) {
                                throw new IllegalArgumentException("Types array must not contain duplicate: " + arg0[i3 - 1].getName() + " and " + dateTimeFieldType.getName());
                            }
                        }
                    } else if (durationField.isSupported() && durationField.getType() != DurationFieldType.YEARS_TYPE) {
                        throw new IllegalArgumentException("Types array must be in order largest-smallest, for year-based fields, years is defined as being largest: " + arg0[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                    }
                }
            }
            durationField = durationField2;
        }
        this.iTypes = (DateTimeFieldType[])arg0.clone();
        arg2.validate(this, arg1);
        this.iValues = (int[])arg1.clone();
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 53278362873888L;
        private final Partial iPartial;
        private final int iFieldIndex;

        public Partial setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iPartial;
        }

        public DateTimeField getField() {
            return this.iPartial.getField(this.iFieldIndex);
        }

        public Partial setCopy(String arg0, Locale arg1) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().set(this.iPartial, this.iFieldIndex, nArray, arg0, arg1);
            return new Partial(this.iPartial, nArray);
        }

        Property(Partial a2, int a3) {
            Property a4;
            a4.iPartial = a2;
            a4.iFieldIndex = a3;
        }

        public Partial withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public Partial addWrapFieldToCopy(int arg0) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().addWrapField(this.iPartial, this.iFieldIndex, nArray, arg0);
            return new Partial(this.iPartial, nArray);
        }

        public Partial addToCopy(int arg0) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().add(this.iPartial, this.iFieldIndex, nArray, arg0);
            return new Partial(this.iPartial, nArray);
        }

        public Partial getPartial() {
            return this.iPartial;
        }

        public Partial withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public Partial setCopy(int arg0) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().set(this.iPartial, this.iFieldIndex, nArray, arg0);
            return new Partial(this.iPartial, nArray);
        }

        public int get() {
            return this.iPartial.getValue(this.iFieldIndex);
        }
    }
}

