/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Minutes
extends BaseSingleFieldPeriod {
    public static final Minutes TWO;
    public static final Minutes MAX_VALUE;
    private static final PeriodFormatter PARSER;
    public static final Minutes ONE;
    public static final Minutes THREE;
    private static final long serialVersionUID = 87525275727380863L;
    public static final Minutes MIN_VALUE;
    public static final Minutes ZERO;

    public Minutes minus(int arg0) {
        return this.plus(FieldUtils.safeNegate(arg0));
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 10080);
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 60));
    }

    static {
        ZERO = new Minutes(0);
        ONE = new Minutes(1);
        TWO = new Minutes(2);
        THREE = new Minutes(3);
        MAX_VALUE = new Minutes(Integer.MAX_VALUE);
        MIN_VALUE = new Minutes(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.minutes());
    }

    @FromString
    public static Minutes parseMinutes(String arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        Period period = PARSER.parsePeriod(arg0);
        return Minutes.minutes(period.getMinutes());
    }

    public static Minutes standardMinutesIn(ReadablePeriod arg0) {
        int n = BaseSingleFieldPeriod.standardPeriodIn(arg0, 60000L);
        return Minutes.minutes(n);
    }

    public Hours toStandardHours() {
        return Hours.hours(this.getValue() / 60);
    }

    private Minutes(int a2) {
        super(a2);
        Minutes a3;
    }

    public Duration toStandardDuration() {
        long l2 = this.getValue();
        return new Duration(l2 * 60000L);
    }

    public static Minutes minutesBetween(ReadableInstant arg0, ReadableInstant arg1) {
        int n = BaseSingleFieldPeriod.between(arg0, arg1, DurationFieldType.minutes());
        return Minutes.minutes(n);
    }

    public Minutes plus(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        return Minutes.minutes(FieldUtils.safeAdd(this.getValue(), arg0));
    }

    private Object readResolve() {
        Minutes a2;
        return Minutes.minutes(a2.getValue());
    }

    public DurationFieldType getFieldType() {
        return DurationFieldType.minutes();
    }

    public Minutes negated() {
        return Minutes.minutes(FieldUtils.safeNegate(this.getValue()));
    }

    public Minutes dividedBy(int arg0) {
        if (arg0 == 1) {
            return this;
        }
        return Minutes.minutes(this.getValue() / arg0);
    }

    @ToString
    public String toString() {
        return "PT" + String.valueOf(this.getValue()) + "M";
    }

    public boolean isLessThan(Minutes arg0) {
        if (arg0 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < arg0.getValue();
    }

    public static Minutes minutes(int arg0) {
        switch (arg0) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Minutes(arg0);
    }

    public PeriodType getPeriodType() {
        return PeriodType.minutes();
    }

    public Minutes plus(Minutes arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.plus(arg0.getValue());
    }

    public Minutes multipliedBy(int arg0) {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), arg0));
    }

    public static Minutes minutesIn(ReadableInterval arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        int n = BaseSingleFieldPeriod.between(arg0.getStart(), arg0.getEnd(), DurationFieldType.minutes());
        return Minutes.minutes(n);
    }

    public static Minutes minutesBetween(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 instanceof LocalTime && arg1 instanceof LocalTime) {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            int n = chronology.minutes().getDifference(((LocalTime)arg1).getLocalMillis(), ((LocalTime)arg0).getLocalMillis());
            return Minutes.minutes(n);
        }
        int n = BaseSingleFieldPeriod.between(arg0, arg1, ZERO);
        return Minutes.minutes(n);
    }

    public Minutes minus(Minutes arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.minus(arg0.getValue());
    }

    public boolean isGreaterThan(Minutes arg0) {
        if (arg0 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > arg0.getValue();
    }

    public int getMinutes() {
        return this.getValue();
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 1440);
    }
}

