/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalTime
extends BaseLocal
implements ReadablePartial,
Serializable {
    private static final Set<DurationFieldType> TIME_DURATION_TYPES;
    private static final int MILLIS_OF_SECOND = 3;
    private static final int MINUTE_OF_HOUR = 1;
    private static final long serialVersionUID = -12873158713873L;
    private final long iLocalMillis;
    public static final LocalTime MIDNIGHT;
    private final Chronology iChronology;
    private static final int SECOND_OF_MINUTE = 2;
    private static final int HOUR_OF_DAY = 0;

    public LocalTime plusMinutes(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof LocalTime) {
            LocalTime localTime = (LocalTime)arg0;
            if (this.iChronology.equals(localTime.iChronology)) {
                return this.iLocalMillis == localTime.iLocalMillis;
            }
        }
        return super.equals(arg0);
    }

    LocalTime withLocalMillis(long a2) {
        LocalTime a3;
        return a2 == a3.getLocalMillis() ? a3 : new LocalTime(a2, a3.getChronology());
    }

    public int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getLocalMillis());
    }

    public LocalTime withMillisOfSecond(int arg0) {
        return this.withLocalMillis(this.getChronology().millisOfSecond().set(this.getLocalMillis(), arg0));
    }

    public LocalTime(int arg0, int arg1) {
        this(arg0, arg1, 0, 0, ISOChronology.getInstanceUTC());
    }

    public int get(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return arg0.getField(this.getChronology()).get(this.getLocalMillis());
    }

    public LocalTime minusMinutes(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public boolean isSupported(DateTimeFieldType arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!this.isSupported(arg0.getDurationType())) {
            return false;
        }
        DurationFieldType durationFieldType = arg0.getRangeDurationType();
        return this.isSupported(durationFieldType) || durationFieldType == DurationFieldType.days();
    }

    public int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getLocalMillis());
    }

    public LocalTime(Object arg0, Chronology arg1) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        arg1 = partialConverter.getChronology(arg0, arg1);
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iChronology = arg1.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, arg0, arg1, ISODateTimeFormat.localTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public LocalTime withFields(ReadablePartial arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(arg0, this.getLocalMillis()));
    }

    public boolean isSupported(DurationFieldType arg0) {
        if (arg0 == null) {
            return false;
        }
        DurationField durationField = arg0.getField(this.getChronology());
        if (TIME_DURATION_TYPES.contains(arg0) || durationField.getUnitMillis() < this.getChronology().days().getUnitMillis()) {
            return durationField.isSupported();
        }
        return false;
    }

    @ToString
    public String toString() {
        return ISODateTimeFormat.time().print(this);
    }

    public LocalTime(long arg0, DateTimeZone arg1) {
        this(arg0, (Chronology)ISOChronology.getInstance(arg1));
    }

    public static LocalTime fromMillisOfDay(long arg0, Chronology arg1) {
        arg1 = DateTimeUtils.getChronology(arg1).withUTC();
        return new LocalTime(arg0, arg1);
    }

    public LocalTime minusHours(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public static LocalTime fromMillisOfDay(long arg0) {
        return LocalTime.fromMillisOfDay(arg0, null);
    }

    public LocalTime plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public LocalTime plusSeconds(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public static LocalTime now() {
        return new LocalTime();
    }

    public String toString(String arg0, Locale arg1) throws IllegalArgumentException {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).withLocale(arg1).print(this);
    }

    public LocalTime(long arg0, Chronology arg1) {
        arg1 = DateTimeUtils.getChronology(arg1);
        long l2 = arg1.getZone().getMillisKeepLocal(DateTimeZone.UTC, arg0);
        arg1 = arg1.withUTC();
        this.iLocalMillis = arg1.millisOfDay().get(l2);
        this.iChronology = arg1;
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public LocalTime plusMillis(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalTime withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(arg0, this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    public DateTime toDateTimeToday() {
        return this.toDateTimeToday(null);
    }

    public LocalTime withSecondOfMinute(int arg0) {
        return this.withLocalMillis(this.getChronology().secondOfMinute().set(this.getLocalMillis(), arg0));
    }

    public static LocalTime now(Chronology arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalTime(arg0);
    }

    public LocalTime minusMillis(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public static LocalTime fromDateFields(Date arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new LocalTime(arg0.getHours(), arg0.getMinutes(), arg0.getSeconds(), ((int)(arg0.getTime() % 1000L) + 1000) % 1000);
    }

    @FromString
    public static LocalTime parse(String arg0) {
        return LocalTime.parse(arg0, ISODateTimeFormat.localTimeParser());
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public DateTime toDateTimeToday(DateTimeZone arg0) {
        Chronology chronology = this.getChronology().withZone(arg0);
        long l2 = DateTimeUtils.currentTimeMillis();
        long l3 = chronology.set(this, l2);
        return new DateTime(l3, chronology);
    }

    private Object readResolve() {
        LocalTime a2;
        if (a2.iChronology == null) {
            return new LocalTime(a2.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (!DateTimeZone.UTC.equals(a2.iChronology.getZone())) {
            return new LocalTime(a2.iLocalMillis, a2.iChronology.withUTC());
        }
        return a2;
    }

    public int size() {
        return 4;
    }

    public LocalTime withMillisOfDay(int arg0) {
        return this.withLocalMillis(this.getChronology().millisOfDay().set(this.getLocalMillis(), arg0));
    }

    public LocalTime withField(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        long l2 = arg0.getField(this.getChronology()).set(this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    static {
        MIDNIGHT = new LocalTime(0, 0, 0, 0);
        TIME_DURATION_TYPES = new HashSet<DurationFieldType>();
        TIME_DURATION_TYPES.add(DurationFieldType.millis());
        TIME_DURATION_TYPES.add(DurationFieldType.seconds());
        TIME_DURATION_TYPES.add(DurationFieldType.minutes());
        TIME_DURATION_TYPES.add(DurationFieldType.hours());
    }

    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    public LocalTime plusHours(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalTime(Object arg0) {
        this(arg0, (Chronology)null);
    }

    public static LocalTime fromCalendarFields(Calendar arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new LocalTime(arg0.get(11), arg0.get(12), arg0.get(13), arg0.get(14));
    }

    public LocalTime(Chronology arg0) {
        this(DateTimeUtils.currentTimeMillis(), arg0);
    }

    public LocalTime withMinuteOfHour(int arg0) {
        return this.withLocalMillis(this.getChronology().minuteOfHour().set(this.getLocalMillis(), arg0));
    }

    public LocalTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalTime(DateTimeZone arg0) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(arg0));
    }

    public int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public LocalTime(int arg0, int arg1, int arg2, int arg3) {
        this(arg0, arg1, arg2, arg3, ISOChronology.getInstanceUTC());
    }

    public int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getLocalMillis());
    }

    public String toString(String arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).print(this);
    }

    public int getValue(int arg0) {
        switch (arg0) {
            case 0: {
                return this.getChronology().hourOfDay().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().minuteOfHour().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().secondOfMinute().get(this.getLocalMillis());
            }
            case 3: {
                return this.getChronology().millisOfSecond().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public static LocalTime parse(String arg0, DateTimeFormatter arg1) {
        return arg1.parseLocalTime(arg0);
    }

    public LocalTime withHourOfDay(int arg0) {
        return this.withLocalMillis(this.getChronology().hourOfDay().set(this.getLocalMillis(), arg0));
    }

    public LocalTime withFieldAdded(DurationFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        if (arg1 == 0) {
            return this;
        }
        long l2 = arg0.getField(this.getChronology()).add(this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        switch (arg0) {
            case 0: {
                return arg1.hourOfDay();
            }
            case 1: {
                return arg1.minuteOfHour();
            }
            case 2: {
                return arg1.secondOfMinute();
            }
            case 3: {
                return arg1.millisOfSecond();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public LocalTime(Object arg0, DateTimeZone arg1) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        Chronology chronology = partialConverter.getChronology(arg0, arg1);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, arg0, chronology, ISODateTimeFormat.localTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public Property property(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return new Property(this, arg0.getField(this.getChronology()));
    }

    public LocalTime(int arg0, int arg1, int arg2, int arg3, Chronology arg4) {
        arg4 = DateTimeUtils.getChronology(arg4).withUTC();
        long l2 = arg4.getDateTimeMillis(0L, arg0, arg1, arg2, arg3);
        this.iChronology = arg4;
        this.iLocalMillis = l2;
    }

    public LocalTime(int arg0, int arg1, int arg2) {
        this(arg0, arg1, arg2, 0, ISOChronology.getInstanceUTC());
    }

    public LocalTime(long arg0) {
        this(arg0, (Chronology)ISOChronology.getInstance());
    }

    public int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getLocalMillis());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public LocalTime minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public int compareTo(ReadablePartial arg0) {
        if (this == arg0) {
            return 0;
        }
        if (arg0 instanceof LocalTime) {
            LocalTime localTime = (LocalTime)arg0;
            if (this.iChronology.equals(localTime.iChronology)) {
                return this.iLocalMillis < localTime.iLocalMillis ? -1 : (this.iLocalMillis == localTime.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(arg0);
    }

    public static LocalTime now(DateTimeZone arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalTime(arg0);
    }

    public LocalTime minusSeconds(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -325842547277223L;
        private transient LocalTime iInstant;
        private transient DateTimeField iField;

        public LocalTime setCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), arg0));
        }

        public LocalTime roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public LocalTime addNoWrapToCopy(int arg0) {
            long l2 = this.iField.add(this.iInstant.getLocalMillis(), arg0);
            long l3 = this.iInstant.getChronology().millisOfDay().get(l2);
            if (l3 != l2) {
                throw new IllegalArgumentException("The addition exceeded the boundaries of LocalTime");
            }
            return this.iInstant.withLocalMillis(l2);
        }

        public DateTimeField getField() {
            return this.iField;
        }

        public LocalTime addWrapFieldToCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), arg0));
        }

        public LocalTime roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            Property a3;
            a2.writeObject(a3.iInstant);
            a2.writeObject(a3.iField.getType());
        }

        public LocalTime withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public LocalTime getLocalTime() {
            return this.iInstant;
        }

        public LocalTime roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }

        public LocalTime setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public LocalTime withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public LocalTime setCopy(String arg0, Locale arg1) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), arg0, arg1));
        }

        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        protected long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        public LocalTime addCopy(long arg0) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), arg0));
        }

        public LocalTime roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        Property(LocalTime a2, DateTimeField a3) {
            Property a4;
            a4.iInstant = a2;
            a4.iField = a3;
        }

        public LocalTime addCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), arg0));
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            Property a3;
            a3.iInstant = (LocalTime)a2.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)a2.readObject();
            a3.iField = dateTimeFieldType.getField(a3.iInstant.getChronology());
        }
    }
}

