/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Hours
extends BaseSingleFieldPeriod {
    public static final Hours SIX;
    public static final Hours TWO;
    public static final Hours SEVEN;
    public static final Hours FIVE;
    public static final Hours ONE;
    private static final long serialVersionUID = 87525275727380864L;
    public static final Hours THREE;
    private static final PeriodFormatter PARSER;
    public static final Hours MAX_VALUE;
    public static final Hours FOUR;
    public static final Hours ZERO;
    public static final Hours MIN_VALUE;
    public static final Hours EIGHT;

    public static Hours hours(int arg0) {
        switch (arg0) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 8: {
                return EIGHT;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Hours(arg0);
    }

    public Hours negated() {
        return Hours.hours(FieldUtils.safeNegate(this.getValue()));
    }

    public static Hours hoursBetween(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 instanceof LocalTime && arg1 instanceof LocalTime) {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            int n = chronology.hours().getDifference(((LocalTime)arg1).getLocalMillis(), ((LocalTime)arg0).getLocalMillis());
            return Hours.hours(n);
        }
        int n = BaseSingleFieldPeriod.between(arg0, arg1, ZERO);
        return Hours.hours(n);
    }

    public Hours minus(Hours arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.minus(arg0.getValue());
    }

    public DurationFieldType getFieldType() {
        return DurationFieldType.hours();
    }

    public int getHours() {
        return this.getValue();
    }

    public Hours plus(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        return Hours.hours(FieldUtils.safeAdd(this.getValue(), arg0));
    }

    public Duration toStandardDuration() {
        long l2 = this.getValue();
        return new Duration(l2 * 3600000L);
    }

    public static Hours hoursIn(ReadableInterval arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        int n = BaseSingleFieldPeriod.between(arg0.getStart(), arg0.getEnd(), DurationFieldType.hours());
        return Hours.hours(n);
    }

    public Hours minus(int arg0) {
        return this.plus(FieldUtils.safeNegate(arg0));
    }

    @FromString
    public static Hours parseHours(String arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        Period period = PARSER.parsePeriod(arg0);
        return Hours.hours(period.getHours());
    }

    public static Hours standardHoursIn(ReadablePeriod arg0) {
        int n = BaseSingleFieldPeriod.standardPeriodIn(arg0, 3600000L);
        return Hours.hours(n);
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 24);
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 60));
    }

    static {
        ZERO = new Hours(0);
        ONE = new Hours(1);
        TWO = new Hours(2);
        THREE = new Hours(3);
        FOUR = new Hours(4);
        FIVE = new Hours(5);
        SIX = new Hours(6);
        SEVEN = new Hours(7);
        EIGHT = new Hours(8);
        MAX_VALUE = new Hours(Integer.MAX_VALUE);
        MIN_VALUE = new Hours(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.hours());
    }

    public static Hours hoursBetween(ReadableInstant arg0, ReadableInstant arg1) {
        int n = BaseSingleFieldPeriod.between(arg0, arg1, DurationFieldType.hours());
        return Hours.hours(n);
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 168);
    }

    private Hours(int a2) {
        super(a2);
        Hours a3;
    }

    private Object readResolve() {
        Hours a2;
        return Hours.hours(a2.getValue());
    }

    public boolean isLessThan(Hours arg0) {
        if (arg0 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < arg0.getValue();
    }

    public Hours plus(Hours arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.plus(arg0.getValue());
    }

    public Hours multipliedBy(int arg0) {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), arg0));
    }

    public boolean isGreaterThan(Hours arg0) {
        if (arg0 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > arg0.getValue();
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 3600));
    }

    @ToString
    public String toString() {
        return "PT" + String.valueOf(this.getValue()) + "H";
    }

    public PeriodType getPeriodType() {
        return PeriodType.hours();
    }

    public Hours dividedBy(int arg0) {
        if (arg0 == 1) {
            return this;
        }
        return Hours.hours(this.getValue() / arg0);
    }
}

