/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.datastructure.multivariate;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.datastructure.multivariate.MultivariateTimeSeries;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateGenericTimeTimeSeries<T extends Comparable<? super T>>
implements MultivariateTimeSeries<T, MultivariateTimeSeries.Entry<T>> {
    private final ArrayList<MultivariateTimeSeries.Entry<T>> new = new ArrayList();

    public MultivariateGenericTimeTimeSeries(T[] timestamps, Matrix values) {
        int a2 = values.nRows();
        ArgumentAssertion.assertTrue(timestamps.length == a2, "number of values and numbers of timestamps do not match", new Object[0]);
        for (int a3 = 0; a3 < timestamps.length; ++a3) {
            this.new.add(new MultivariateTimeSeries.Entry<T>(timestamps[a3], values.getRow(a3 + 1)));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultivariateGenericTimeTimeSeries a2 = (MultivariateGenericTimeTimeSeries)obj;
        return this.new == a2.new || this.new != null && this.new.equals(a2.new);
    }

    public MultivariateGenericTimeTimeSeries(T[] timestamps, double[][] values) {
        ArgumentAssertion.assertTrue(timestamps.length == values.length, "number of values and numbers of timestamps do not match", new Object[0]);
        for (int a2 = 0; a2 < timestamps.length; ++a2) {
            this.new.add(new MultivariateTimeSeries.Entry<T>(timestamps[a2], new DenseVector(values[a2])));
        }
    }

    public MultivariateGenericTimeTimeSeries<T> diff(int d2) {
        Comparable[] a2 = this.timestamps();
        Vector[] a3 = this.toArray();
        Matrix a4 = MatrixFactory.rbind(a3);
        double[][] a5 = MatrixUtils.to2DArray(a4);
        double[][] a6 = DoubleUtils.diff(a5, 1, d2);
        Comparable[] a7 = Arrays.copyOfRange(a2, d2, a2.length);
        return new MultivariateGenericTimeTimeSeries(a7, a6);
    }

    public T[] timestamps() {
        int a2 = this.new.size();
        Comparable[] a3 = (Comparable[])Array.newInstance(((Comparable)this.new.get(0).getTime()).getClass(), a2);
        for (int a4 = 0; a4 < a2; ++a4) {
            a3[a4] = (Comparable)this.new.get(a4).getTime();
        }
        return a3;
    }

    @Override
    public int size() {
        return this.new.size();
    }

    public MultivariateGenericTimeTimeSeries<T> drop(int nItems) {
        Comparable[] a2 = this.timestamps();
        Vector[] a3 = this.toArray();
        Vector[] a4 = Arrays.copyOfRange(a3, nItems, a3.length);
        Comparable[] a5 = Arrays.copyOfRange(a2, nItems, a2.length);
        return new MultivariateGenericTimeTimeSeries(a5, a4);
    }

    public Vector get(int i2) {
        return new ImmutableVector((Vector)this.new.get(i2 - 1).getValue());
    }

    public MultivariateGenericTimeTimeSeries(T[] timestamps, Vector[] values) {
        ArgumentAssertion.assertTrue(timestamps.length == values.length, "number of values and numbers of timestamps do not match", new Object[0]);
        for (int a2 = 0; a2 < timestamps.length; ++a2) {
            this.new.add(new MultivariateTimeSeries.Entry<T>(timestamps[a2], values[a2]));
        }
    }

    public Vector[] toArray() {
        int a2 = this.new.size();
        Vector[] a3 = new Vector[a2];
        for (int a4 = 0; a4 < a2; ++a4) {
            a3[a4] = new ImmutableVector((Vector)this.new.get(a4).getValue());
        }
        return a3;
    }

    public String toString() {
        int a2 = this.size();
        StringBuilder a3 = new StringBuilder(a2);
        a3.append("{");
        for (int a4 = 0; a4 < a2; ++a4) {
            a3.append(String.format("%s: %s;\n", this.time(a4 + 1), this.get(a4 + 1)));
        }
        a3.setCharAt(a3.length() - 2, '}');
        return a3.toString();
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 13 * a2 + (this.new != null ? this.new.hashCode() : 0);
        return a2;
    }

    @Override
    public Iterator<MultivariateTimeSeries.Entry<T>> iterator() {
        return new Iterator<MultivariateTimeSeries.Entry<T>>(){
            private final Iterator<MultivariateTimeSeries.Entry<T>> new;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }

            @Override
            public boolean hasNext() {
                return this.new.hasNext();
            }

            @Override
            public MultivariateTimeSeries.Entry<T> next() {
                MultivariateTimeSeries.Entry a2 = this.new.next();
                return new MultivariateTimeSeries.Entry(a2.getTime(), (Vector)a2.getValue());
            }
            {
                1 a3;
                a3.new = a3.MultivariateGenericTimeTimeSeries.this.new.iterator();
            }
        };
    }

    @Override
    public int dimension() {
        return this.new.get(0).getValue().size();
    }

    public T time(int i2) {
        return (T)((Comparable)this.new.get(i2 - 1).getTime());
    }

    @Override
    public Matrix toMatrix() {
        Vector[] a2 = this.toArray();
        Matrix a3 = MatrixFactory.rbind(a2);
        return a3;
    }
}

