/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.variance;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.descriptive.moment.Variance;
import dev.nm.stat.distribution.univariate.FDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.test.HypothesisTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class F
extends HypothesisTest {
    private final Variance void;
    private final double if;
    private final Variance new;

    @Override
    public double pValue() {
        double a2 = 2.0 * Math.min(this.rightOneSidedPvalue(), this.leftOneSidedPvalue());
        return a2;
    }

    public double leftOneSidedPvalue() {
        double a2 = 1.0 - this.rightOneSidedPvalue();
        return a2;
    }

    public double rightOneSidedPvalue() {
        double a2 = this.statistics();
        double a3 = F.oneSidedPvalue(this.final(), a2);
        return a3;
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the two samples have different variances";
    }

    public F(double[] sample1, double[] sample2) {
        this(sample1, sample2, 1.0);
    }

    @Override
    public String getNullHypothesis() {
        return "the two normal populations have the same variance";
    }

    public double rightConfidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        double a2 = this.new.value() / this.void.value();
        return a2 / this.final().quantile(confidence);
    }

    private ProbabilityDistribution final() {
        F a2;
        int a3 = (int)a2.new.N() - 1;
        int a4 = (int)a2.void.N() - 1;
        FDistribution a5 = new FDistribution(a3, a4);
        return a5;
    }

    public double[] confidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        double a2 = this.new.value() / this.void.value();
        double[] a3 = new double[]{a2 / this.final().quantile(confidence), a2 / this.final().quantile(1.0 - confidence)};
        return a3;
    }

    @Override
    public double statistics() {
        double a2 = this.new.value();
        double a3 = this.void.value();
        double a4 = a2 / a3;
        double a5 = a4 / this.if;
        return a5;
    }

    public F(double[] sample1, double[] sample2, double ratio) {
        super(sample1, sample2);
        this.if = ratio;
        this.new = new Variance(sample1);
        this.void = new Variance(sample2);
    }

    public double leftConfidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        double a2 = this.new.value() / this.void.value();
        return a2 / this.final().quantile(1.0 - confidence);
    }
}

