/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.timeseries.adf;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.algebra.structure.AbelianGroup;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.regression.linear.LMProblem;
import dev.nm.stat.regression.linear.ols.OLSRegression;
import dev.nm.stat.test.HypothesisTest;
import dev.nm.stat.test.timeseries.adf.ADFDistribution;
import dev.nm.stat.test.timeseries.adf.TrendType;
import dev.nm.stat.timeseries.datastructure.univariate.UnivariateTimeSeriesUtils;
import dev.nm.stat.timeseries.datastructure.univariate.realtime.inttime.SimpleTimeSeries;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AugmentedDickeyFuller
extends HypothesisTest {
    private final OLSRegression if;
    private final ADFDistribution new;

    @Override
    public double statistics() {
        double a2 = this.if.beta().betaHat().get(1);
        double a3 = this.if.beta().stderr().get(1);
        double a4 = a2 / a3;
        return a4;
    }

    @Override
    public double pValue() {
        double a2 = this.statistics();
        double a3 = this.new.cdf(a2);
        return a3;
    }

    public AugmentedDickeyFuller(double[] x, TrendType type, int lagOrder, ADFDistribution dist) {
        this(new SimpleTimeSeries(x), type, lagOrder, dist);
    }

    public AugmentedDickeyFuller(double[] x) {
        this(x, TrendType.CONSTANT_TIME, (int)Math.pow(x.length - 1, 0.3333333333333333), null);
    }

    @Override
    public String getNullHypothesis() {
        return "there is a unit root in the process, hence non-stationarity";
    }

    @Override
    public String getAlternativeHypothesis() {
        return "there is no unit root in the process, hence stationarity";
    }

    private AugmentedDickeyFuller(SimpleTimeSeries a2, TrendType a3, int a4, ADFDistribution a5) {
        super(new double[0][]);
        AbelianGroup<Vector> a6;
        AugmentedDickeyFuller a7;
        ArgumentAssertion.assertTrue(0 <= a4 && a4 < a2.size(), "0 <= lagOrder < sample size", new Object[0]);
        SimpleTimeSeries a8 = a2.diff(1);
        int a9 = a8.size();
        Vector a10 = UnivariateTimeSeriesUtils.toVector(a8.drop(a4));
        Vector a11 = VectorFactory.subVector(UnivariateTimeSeriesUtils.toVector(a2), a4 + 1, a9);
        DenseVector a12 = new DenseVector(DoubleUtils.seq((double)a4 + 1.0, (double)a9, 1.0));
        ArrayList<Vector> a13 = new ArrayList<Vector>();
        a13.add(a11);
        a13.add(a12);
        if (a4 > 0) {
            a6 = UnivariateTimeSeriesUtils.toVector(a8);
            for (int a14 = 2; a14 <= a4 + 1; ++a14) {
                Vector a15 = VectorFactory.subVector(a6, a4 - a14 + 2, a9 - a14 + 1);
                a13.add(a15);
            }
        }
        a6 = MatrixFactory.cbind(a13);
        LMProblem a16 = new LMProblem(a10, (Matrix)a6, true);
        a7.if = new OLSRegression(a16);
        a7.new = a5 != null ? a5 : a3.getDistribution(a2.size());
    }
}

