/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.rank.wilcoxon;

import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WilcoxonSignedRankDistribution
implements ProbabilityDistribution {
    private double[][] if;
    private final int new;

    static {
        Package.validate("NMDEV_STAT");
    }

    public double rightOneSidedPvalue(double x) {
        double a2 = 0.0;
        for (int a3 = 0; a3 <= WilcoxonSignedRankDistribution.final(this.new); ++a3) {
            if (!((double)a3 >= x)) continue;
            a2 += this.if[this.new][a3];
        }
        return a2;
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        return (double)(this.new * (this.new + 1)) / 4.0;
    }

    public WilcoxonSignedRankDistribution(int N) {
        int a2;
        int a3;
        int a4;
        this.new = N;
        this.if = new double[N + 1][];
        this.if[0] = new double[1];
        this.if[0][0] = 1.0;
        for (a4 = 1; a4 <= N; ++a4) {
            a3 = WilcoxonSignedRankDistribution.final(a4);
            this.if[a4] = new double[a3 + 1];
            for (a2 = 0; a2 <= a3; ++a2) {
                double a5 = a2 < this.if[a4 - 1].length ? this.if[a4 - 1][a2] : 0.0;
                double a6 = a2 - a4 >= 0 ? this.if[a4 - 1][a2 - a4] : 0.0;
                this.if[a4][a2] = a5 + a6;
            }
        }
        for (a4 = 1; a4 <= N; ++a4) {
            for (a3 = 0; a3 < this.if[a4].length; ++a3) {
                for (a2 = 1; a2 <= a4; ++a2) {
                    double[] dArray = this.if[a4];
                    int n = a3;
                    dArray[n] = dArray[n] / 2.0;
                }
            }
        }
    }

    @Override
    public double variance() {
        return (double)(this.new * (this.new + 1) * (2 * this.new + 1)) / 24.0;
    }

    @Override
    public double cdf(double x) {
        double a2 = 0.0;
        for (int a3 = 0; a3 <= WilcoxonSignedRankDistribution.final(this.new); ++a3) {
            if (!((double)a3 <= x)) continue;
            a2 += this.if[this.new][a3];
        }
        return a2;
    }

    private static int final(int a2) {
        return a2 * (a2 + 1) / 2;
    }

    @Override
    @Deprecated
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double quantile(double u) {
        int a2;
        double a3 = 0.0;
        int a4 = 0;
        for (a2 = 0; a2 <= WilcoxonSignedRankDistribution.final(this.new); ++a2) {
            while (a4 <= a2 && a4 <= WilcoxonSignedRankDistribution.final(this.new)) {
                a3 += this.if[this.new][a4];
                ++a4;
            }
            if (a3 >= u) break;
        }
        return a2;
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double density(double x) {
        return this.if[this.new][(int)x];
    }

    public double pValue(double x) {
        double a2 = this.cdf(x);
        double a3 = this.rightOneSidedPvalue(x);
        double a4 = 2.0 * Math.min(a3, a2);
        return a4;
    }
}

