/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test;

import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.EmpiricalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class HypothesisTest {
    private final int if;
    private final int new;

    protected HypothesisTest(double[] ... samples) {
        this.new = samples.length;
        int a2 = 0;
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2 += samples[a3] != null ? samples[a3].length : 0;
        }
        this.if = a2;
    }

    public int nObs() {
        return this.if;
    }

    public static double oneSidedPvalue(ProbabilityDistribution F2, double x) {
        if (F2 instanceof EmpiricalDistribution) {
            return 1.0 - F2.cdf(x) + F2.density(x);
        }
        return 1.0 - F2.cdf(x);
    }

    public abstract String getAlternativeHypothesis();

    public boolean isNullRejected(double alpha) {
        return this.pValue() < alpha;
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public abstract double statistics();

    public int nGroups() {
        return this.new;
    }

    public abstract String getNullHypothesis();

    public abstract double pValue();
}

