/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.glm.modelselection;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.regression.linear.glm.GLMProblem;
import dev.nm.stat.regression.linear.glm.GeneralizedLinearModel;
import dev.nm.stat.regression.linear.glm.modelselection.ForwardSelection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SelectionByZValue
implements ForwardSelection.Step {
    private final double new;

    public SelectionByZValue(double significance) {
        ArgumentAssertion.assertRange(significance, 0.0, 1.0, "significance level");
        this.new = new NormalDistribution(0.0, 1.0).quantile(1.0 - significance / 2.0);
    }

    @Override
    public int select(GLMProblem problem, Matrix subA, int[] factorChoices) {
        double a2 = Double.NEGATIVE_INFINITY;
        int a3 = 0;
        for (int a4 : factorChoices) {
            Matrix a5 = MatrixFactory.cbind(new DenseMatrix(problem.A().getColumn(a4)), subA);
            GLMProblem a6 = new GLMProblem((Vector)problem.y(), a5, problem.intercept(), problem.getFamily());
            GeneralizedLinearModel a7 = new GeneralizedLinearModel(a6);
            double[] a8 = a7.beta().t().toArray();
            if (!(Math.abs(a8[0]) > a2)) continue;
            a2 = Math.abs(a8[0]);
            a3 = a4;
        }
        if (a2 >= this.new) {
            return a3;
        }
        return -1;
    }
}

