/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.glm.distribution;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.stat.regression.linear.glm.distribution.GLMExponentialDistribution;

public class GLMInverseGaussian
implements GLMExponentialDistribution {
    @Override
    public double overdispersion(Vector y, Vector mu, int nFactors) {
        int a2 = y.size();
        double a3 = 0.0;
        for (int a4 = 1; a4 <= a2; ++a4) {
            double a5 = (y.get(a4) - mu.get(a4)) / Math.pow(mu.get(a4), 1.5);
            a3 += a5 * a5;
        }
        return a3 /= (double)(a2 - nFactors);
    }

    @Override
    public double AIC(Vector y, Vector mu, Vector weight, double prelogLike, double deviance, int nFactors) {
        int a2 = y.size();
        double a3 = deviance / (double)a2;
        double a4 = prelogLike / a3 - (double)a2 * Math.log(Math.PI * 2 * a3) / 2.0;
        for (int a5 = 1; a5 <= a2; ++a5) {
            a4 += -(3.0 * Math.log(y.get(a5)) + 1.0 / (a3 * y.get(a5))) / 2.0;
        }
        return 2.0 * ((double)(nFactors + 1) - a4);
    }

    @Override
    public double theta(double mu) {
        return -1.0 / (2.0 * mu * mu);
    }

    @Override
    public double cumulant(double theta) {
        return -Math.sqrt(-2.0 * theta);
    }

    @Override
    public double variance(double mu) {
        return mu * mu * mu;
    }

    @Override
    public double deviance(double y, double mu) {
        double a2 = y - mu;
        return a2 * a2 / (y * mu * mu);
    }

    @Override
    public double dispersion(Vector y, Vector mu, int nFactors) {
        return this.overdispersion(y, mu, nFactors);
    }
}

