/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.univariate.uniform.linear;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.random.rng.univariate.uniform.linear.LinearCongruentialGenerator;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CompositeLinearCongruentialGenerator
implements LinearCongruentialGenerator {
    private final long if;
    private LinearCongruentialGenerator[] new;

    @Override
    public long nextLong() {
        long a2 = 0L;
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            long a4 = this.new[a3].nextLong();
            a2 = a3 % 2 == 1 ? (a2 -= a4) : (a2 += a4);
            while (a2 < 0L) {
                a2 += this.if;
            }
            if (a2 <= this.if) continue;
            a2 %= this.if;
        }
        return a2;
    }

    @Override
    public long modulus() {
        return this.if;
    }

    public CompositeLinearCongruentialGenerator(LinearCongruentialGenerator[] rng) {
        ArgumentAssertion.assertTrue(rng.length > 0, "no random generator was found", new Object[0]);
        this.new = rng;
        long a2 = 0L;
        for (int a3 = 0; a3 < rng.length; ++a3) {
            if (rng[a3].modulus() <= a2) continue;
            a2 = rng[a3].modulus();
        }
        this.if = a2;
    }

    @Override
    public void seed(long ... seeds) {
        int a2 = 0;
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            long[] a4 = Arrays.copyOfRange(seeds, a2, a2 + this.new[a3].order());
            this.new[a3].seed(a4);
            a2 += this.new[a3].order();
        }
    }

    @Override
    public int order() {
        int a2 = 0;
        for (LinearCongruentialGenerator a3 : this.new) {
            a2 += a3.order();
        }
        return a2;
    }

    @Override
    public double nextDouble() {
        double a2;
        long a3 = this.nextLong();
        if (a3 > 0L) {
            a2 = (double)a3 / (double)(this.if - 1L);
        } else if (a3 == 0L) {
            a2 = (double)(this.if - 1L) / (double)this.if;
        } else {
            throw new RuntimeException("-ve. x");
        }
        return a2;
    }
}

