/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.multivariate.mcmc.hybrid;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2rm.AbstractRealVectorFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.stat.random.rng.multivariate.mcmc.hybrid.LeapFrogging;
import dev.nm.stat.random.rng.multivariate.mcmc.metropolis.AbstractMetropolis;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;

public abstract class AbstractHybridMCMC
extends AbstractMetropolis {
    protected double dt;

    public final void setDeltaT(double dt) {
        this.dt = dt;
    }

    public static double k(Vector p, Vector m2) {
        double a2 = 0.0;
        for (int a3 = 1; a3 <= p.size(); ++a3) {
            double a4 = p.get(a3);
            a2 += a4 * a4 / 2.0 / m2.get(a3);
        }
        return a2;
    }

    public static RealVectorFunction dUdx(final RealVectorFunction dLogF) {
        int a2 = dLogF.dimensionOfDomain();
        return new AbstractRealVectorFunction(a2, a2){
            {
                1 a4;
                super(a2, a3);
            }

            @Override
            public Vector evaluate(Vector x) {
                Vector a2 = ((Vector)dLogF.evaluate(x)).scaled(-1.0);
                return a2;
            }
        };
    }

    public static double H(LeapFrogging.DynamicsState state, RealScalarFunction logF, Vector m2) {
        double a2 = -((Double)logF.evaluate(state.x())).doubleValue();
        double a3 = AbstractHybridMCMC.k(state.p(), m2);
        double a4 = a2 + a3;
        return a4;
    }

    public AbstractHybridMCMC(Vector initialState, RandomNumberGenerator rng) {
        super(initialState, rng);
    }
}

