/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyWang2006;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.stat.random.rng.multivariate.IID;
import dev.nm.stat.random.rng.multivariate.RandomVectorGenerator;
import dev.nm.stat.random.rng.univariate.normal.RandomStandardNormalGenerator;
import dev.nm.stat.random.rng.univariate.normal.StandardNormalRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NormalRVG
implements RandomVectorGenerator {
    private final Impl if;
    private final IID new;

    @Override
    public double[] nextVector() {
        return this.if.nextVector();
    }

    public NormalRVG(Vector mu, Matrix sigma) {
        this(mu, sigma, new StandardNormalRNG());
    }

    public NormalRVG(int dim) {
        this.new = new IID(new StandardNormalRNG(), dim);
        this.if = new Impl(){
            {
                3 a3;
            }

            @Override
            public double[] nextVector() {
                return NormalRVG.this.new.nextVector();
            }
        };
    }

    @Override
    public void seed(long ... seeds) {
        this.new.seed(seeds);
    }

    public NormalRVG(Vector mu, Matrix sigma, RandomStandardNormalGenerator rnorm) {
        this(mu, sigma, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(sigma)), rnorm);
    }

    public NormalRVG(final Vector mu, Matrix sigma, double epsilon, RandomStandardNormalGenerator rnorm) {
        ArgumentAssertion.assertTrue(sigma.nRows() == mu.size() && sigma.nCols() == mu.size(), "sigma should be a square matrix of dimension mu.size() by mu.size()", new Object[0]);
        int a2 = mu.size();
        final ImmutableMatrix a3 = new ImmutableMatrix(new CholeskyWang2006(sigma, epsilon).L());
        this.new = new IID(rnorm, a2);
        this.if = MatrixPropertyUtils.isZero(mu, epsilon) ? new Impl(){
            {
                1 a32;
            }

            @Override
            public double[] nextVector() {
                DenseVector a2 = new DenseVector(NormalRVG.this.new.nextVector());
                Vector a32 = a3.multiply(a2);
                return a32.toArray();
            }
        } : new Impl(){

            @Override
            public double[] nextVector() {
                DenseVector a2 = new DenseVector(NormalRVG.this.new.nextVector());
                Vector a32 = mu.add(a3.multiply(a2));
                return a32.toArray();
            }
            {
                2 a32;
            }
        };
    }

    private static interface Impl {
        public double[] nextVector();
    }
}

