/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate.fitting;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.differentiation.multivariate.Hessian;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.evt.evd.univariate.fitting.ConfidenceInterval;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EstimateByLogLikelihood {
    private final RealScalarFunction if;
    private final ImmutableVector new;

    public ConfidenceInterval confidenceInterval(double confidenceLevel) {
        NormalDistribution a2 = new NormalDistribution();
        double a3 = a2.quantile(0.5 + 0.5 * confidenceLevel);
        Vector a4 = this.standardError().scaled(a3);
        Vector a5 = this.new.minus(a4);
        Vector a6 = this.new.add(a4);
        return new ConfidenceInterval(confidenceLevel, this.new, a5, a6);
    }

    public RealScalarFunction getLogLikelihoodFunction() {
        return this.if;
    }

    public double logLikelihood() {
        return (Double)this.if.evaluate(this.new);
    }

    public Matrix covarianceMatrix() {
        Hessian a2 = new Hessian(this.if, this.new);
        Inverse a3 = new Inverse(a2.opposite());
        return a3;
    }

    public Vector standardError() {
        Matrix a2 = this.covarianceMatrix();
        return VectorFactory.diagonal(a2).pow(0.5);
    }

    public EstimateByLogLikelihood(Vector fittedParameters, RealScalarFunction logLikelihoodFunction) {
        this.new = new ImmutableVector(fittedParameters);
        this.if = logLikelihoodFunction;
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    public ImmutableVector getFittedParameters() {
        return this.new;
    }
}

