/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.ExceptionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FDistribution
implements ProbabilityDistribution {
    private final BetaRegularized enum;
    private final BetaRegularizedInverse false;
    private final double void;
    private final double if;
    private static final LogBeta new = new LogBeta();

    @Override
    public double variance() {
        ExceptionUtils.throwIfNotNull(this.void > 4.0 ? null : new UnsupportedOperationException("only supported for df2 > 4"));
        double a2 = 2.0 * this.void * this.void * (this.if + this.void - 2.0);
        return a2 /= this.if * (this.void - 2.0) * (this.void - 2.0) * (this.void - 4.0);
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("does not exist.");
    }

    public FDistribution(double df1, double df2) {
        ArgumentAssertion.assertPositive(df1, "df1");
        ArgumentAssertion.assertPositive(df2, "df2");
        this.if = df1;
        this.void = df2;
        this.enum = new BetaRegularized(df1 / 2.0, df2 / 2.0);
        this.false = new BetaRegularizedInverse(df1 / 2.0, df2 / 2.0);
    }

    @Override
    public double mean() {
        ExceptionUtils.throwIfNotNull(this.void > 2.0 ? null : new UnsupportedOperationException("only supported for df2 > 2"));
        return this.void / (this.void - 2.0);
    }

    @Override
    public double density(double x) {
        ArgumentAssertion.assertNonNegative(x, "x");
        if (DoubleUtils.isZero(x, 0.0)) {
            if (this.if < 2.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.if == 2.0) {
                return 1.0;
            }
            return 0.0;
        }
        double a2 = this.if * Math.log(this.if * x);
        a2 += this.void * Math.log(this.void);
        a2 -= (this.if + this.void) * Math.log(this.if * x + this.void);
        a2 /= 2.0;
        a2 -= Math.log(x);
        a2 -= new.evaluate(this.if / 2.0, this.void / 2.0);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double quantile(double u) {
        double a2 = this.false.evaluate(u);
        return this.void * a2 / (this.if - this.if * a2);
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double kurtosis() {
        ExceptionUtils.throwIfNotNull(this.void > 8.0 ? null : new UnsupportedOperationException("only supported for df2 > 8"));
        double a2 = 5.0 * this.void * this.void * this.if - 22.0 * this.if * this.if + 5.0 * this.void * this.if * this.if - 16.0;
        double a3 = 20.0 * this.void - 8.0 * this.void * this.void + this.void * this.void * this.void + 44.0 * this.if - 32.0 * this.if * this.void + a2;
        return (a3 /= this.if * (this.void - 6.0) * (this.void - 8.0) * (this.if + this.void - 2.0) / 12.0) - 3.0;
    }

    @Override
    public double skew() {
        ExceptionUtils.throwIfNotNull(this.void > 6.0 ? null : new UnsupportedOperationException("only supported for df2 > 6"));
        double a2 = (2.0 * this.if + this.void - 2.0) * Math.sqrt(8.0 * (this.void - 4.0));
        return a2 /= (this.void - 6.0) * Math.sqrt(this.if * (this.if + this.void - 2.0));
    }

    @Override
    public double cdf(double x) {
        ArgumentAssertion.assertNonNegative(x, "x");
        return this.enum.evaluate(this.if * x / (this.if * x + this.void));
    }
}

