/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.rank;

import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Rank {
    private final double void;
    private final double[] if;
    private final double new;

    public double rank(int i2) {
        return this.if[i2];
    }

    private int[] final(double[] a4) {
        int a5 = a4.length;
        Entry[] a6 = new Entry[a5];
        for (int a7 = 0; a7 < a5; ++a7) {
            a6[a7] = new Entry(a7, a4[a7]);
        }
        Arrays.sort(a6, (a2, a3) -> Double.compare(((Entry)a2).if, ((Entry)a3).if));
        int[] a8 = new int[a5];
        for (int a9 = 0; a9 < a5; ++a9) {
            a8[a9] = a6[a9].new;
            a4[a9] = a6[a9].if;
        }
        return a8;
    }

    public Rank(double[] values, TiesMethod tiesMethod) {
        this(values, PrecisionUtils.autoEpsilon(values), tiesMethod);
    }

    public Rank(double[] values, double threshold) {
        this(values, threshold, TiesMethod.AS_26);
    }

    public double[] ranks() {
        return Arrays.copyOf(this.if, this.if.length);
    }

    public Rank(double[] values, double threshold, TiesMethod tiesMethod) {
        int a2;
        double a3 = 0.0;
        double a4 = 0.0;
        int a5 = values.length;
        double[] a6 = Arrays.copyOf(values, a5);
        int[] a7 = this.final(a6);
        double[] a8 = new double[a5];
        a8[a5 - 1] = a5 - 1;
        for (a2 = 0; a2 < a5 - 1; ++a2) {
            if (Math.abs(a6[a2] - a6[a2 + 1]) > threshold) {
                a8[a2] = a2;
                continue;
            }
            int a9 = 2;
            for (int a10 = a2 + 1; a10 < a5 - 1 && Math.abs(a6[a10] - a6[a10 + 1]) < threshold; ++a10) {
                ++a9;
            }
            double[] a11 = tiesMethod.ranksForTies(a2, a9);
            for (int a12 = 0; a12 < a9; ++a12) {
                a8[a2 + a12] = a11[a12];
            }
            double a13 = (a9 - 1) * a9;
            a4 += a13;
            a3 += a13 * (double)(a9 + 1);
            a2 += a9 - 1;
        }
        this.void = a4;
        this.new = a3;
        this.if = new double[a5];
        for (a2 = 0; a2 < a5; ++a2) {
            this.if[a7[a2]] = a8[a2] + 1.0;
        }
    }

    public Rank(double[] values) {
        this(values, PrecisionUtils.autoEpsilon(values));
    }

    public double t() {
        return this.new;
    }

    public double s() {
        return this.void;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum TiesMethod {
        AS_26{
            {
                1 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.final(a3, (double)a2 + 0.5 * (double)(a3 - 1));
            }
        }
        ,
        AVERAGE{

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.final(a3, (double)a2 + 0.5 * (double)(a3 - 1));
            }
            {
                2 a2;
            }
        }
        ,
        FIRST{
            {
                3 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                return DoubleUtils.seq(a3, (double)a2, 1.0);
            }
        }
        ,
        LAST{
            {
                4 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                return DoubleUtils.seq(a3, (double)(a2 + a3 - 1), -1.0);
            }
        }
        ,
        RANDOM{
            {
                5 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                ArrayList<Double> a4 = new ArrayList<Double>(a3);
                for (int a5 = 0; a5 < a3; ++a5) {
                    a4.add(Double.valueOf(a2 + a5));
                }
                Collections.shuffle(a4);
                double[] a6 = DoubleUtils.collection2DoubleArray(a4);
                return a6;
            }
        }
        ,
        MAX{
            {
                6 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.final(a3, a2 + a3 - 1);
            }
        }
        ,
        MIN{
            {
                7 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.final(a3, a2);
            }
        };


        private TiesMethod() {
            TiesMethod a2;
        }

        private static double[] final(int a2, double a3) {
            return DoubleUtils.rep(a3, a2);
        }

        abstract double[] ranksForTies(int var1, int var2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Entry {
        private final double if;
        private final int new;

        private Entry(int a2, double a3) {
            Entry a4;
            a4.new = a2;
            a4.if = a3;
        }
    }
}

