/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.SubFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarSubFunction;
import dev.nm.solver.multivariate.constrained.ConstrainedMinimizer;
import dev.nm.solver.multivariate.constrained.ConstrainedOptimSubProblem;
import dev.nm.solver.multivariate.constrained.constraint.Constraints;
import dev.nm.solver.multivariate.constrained.constraint.ConstraintsUtils;
import dev.nm.solver.multivariate.constrained.constraint.EqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.LessThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.general.GeneralEqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.general.GeneralLessThanConstraints;
import dev.nm.solver.multivariate.constrained.general.penaltymethod.PenaltyMethodMinimizer;
import dev.nm.solver.multivariate.constrained.general.sqp.activeset.SQPActiveSetMinimizer;
import dev.nm.solver.multivariate.constrained.problem.ConstrainedOptimProblem;
import dev.nm.solver.multivariate.constrained.problem.ConstrainedOptimProblemImpl1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SubProblemMinimizer
implements ConstrainedMinimizer<ConstrainedOptimSubProblem, IterativeSolution<Vector>> {
    private final ConstrainedMinimizerFactory<? extends ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>>> new;

    public SubProblemMinimizer(ConstrainedMinimizerFactory<? extends ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>>> factory) {
        this.new = factory;
    }

    @Override
    public dev.nm.solver.IterativeSolution<Vector> solve(ConstrainedOptimProblem subProblem) throws Exception {
        int a2 = subProblem.dimension();
        if (a2 == 0) {
            throw new RuntimeException("there is no degree of freedom in the sub-function");
        }
        if (a2 < 0) {
            throw new RuntimeException("negative degree of freedom; invalid input");
        }
        ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>> a3 = this.new.newInstance();
        final dev.nm.solver.IterativeSolution a4 = (dev.nm.solver.IterativeSolution)a3.solve(subProblem);
        return new dev.nm.solver.IterativeSolution<Vector>(){

            public void setInitials(Vector ... initials) {
                a4.setInitials(initials);
            }

            @Override
            public Vector minimizer() {
                return (Vector)a4.minimizer();
            }

            public Vector search(Vector ... initials) throws Exception {
                Vector a2 = a4.search(initials);
                return a2;
            }

            @Override
            public Object step() throws Exception {
                return a4.step();
            }

            @Override
            public double minimum() {
                return a4.minimum();
            }
            {
                4 a3;
            }
        };
    }

    public SubProblemMinimizer(final double epsilon, final int maxIterations) {
        this((ConstrainedMinimizerFactory<? extends ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>>>)new ConstrainedMinimizerFactory<ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>>>(){

            @Override
            public ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>> newInstance() {
                return new SQPActiveSetMinimizer(epsilon, maxIterations);
            }
            {
                2 a2;
            }
        });
    }

    public IterativeSolution<Vector> solve(ConstrainedOptimProblem problem, Map<Integer, Double> fixing) throws Exception {
        return this.solve(SubProblemMinimizer.getConstrainedOptimSubProblem(problem, fixing));
    }

    public static ConstrainedOptimProblem getSubProblem(ConstrainedOptimSubProblem problem) {
        Object a2;
        Object a3;
        Map<Integer, Double> a4 = problem.fixing();
        RealScalarSubFunction a5 = new RealScalarSubFunction(problem.f(), a4);
        int a6 = a5.dimensionOfDomain();
        GeneralEqualityConstraints a7 = null;
        if (problem.getEqualityConstraints() != null) {
            a3 = new ArrayList<RealScalarFunction>();
            for (RealScalarFunction a8 : problem.getEqualityConstraints().getConstraints()) {
                a3.add((RealScalarFunction)new RealScalarSubFunction(a8, a4));
            }
            a7 = new GeneralEqualityConstraints((Collection<RealScalarFunction>)a3);
            if (a6 == 0 && !ConstraintsUtils.isSatisfied(a7, new DenseVector(0))) {
                throw new RuntimeException("some equality constraints are violated after fixing variables");
            }
        }
        a3 = null;
        if (problem.getLessThanConstraints() != null) {
            a2 = new ArrayList();
            for (RealScalarFunction a9 : problem.getLessThanConstraints().getConstraints()) {
                a2.add(new RealScalarSubFunction(a9, a4));
            }
            a3 = new GeneralLessThanConstraints((Collection<RealScalarFunction>)a2);
            if (a6 == 0 && !ConstraintsUtils.isSatisfied((Constraints)a3, new DenseVector(0))) {
                throw new RuntimeException("some less-than constraints are violated after fixing variables");
            }
        }
        a2 = new ConstrainedOptimProblemImpl1(a5, a7, (LessThanConstraints)a3);
        return a2;
    }

    @Override
    public IterativeSolution<Vector> solve(final ConstrainedOptimSubProblem problem) throws Exception {
        ConstrainedOptimProblem a2 = SubProblemMinimizer.getSubProblem(problem);
        final dev.nm.solver.IterativeSolution<Vector> a3 = this.solve(a2);
        return new IterativeSolution<Vector>(){

            @Override
            public Vector minimizer() {
                return (Vector)a3.minimizer();
            }

            public void setInitials(Vector ... initials) {
                a3.setInitials(initials);
            }

            public Vector search(Vector ... initials) throws Exception {
                Vector a2 = a3.search(initials);
                return a2;
            }

            @Override
            public Object step() throws Exception {
                return a3.step();
            }

            @Override
            public double minimum() {
                return a3.minimum();
            }
            {
                5 a32;
            }

            @Override
            public Vector fullMinimizer() {
                Vector a2 = this.minimizer();
                Vector a32 = SubFunction.getAllParts(a2, problem.fixing());
                return a32;
            }
        };
    }

    public static ConstrainedOptimSubProblem getConstrainedOptimSubProblem(final ConstrainedOptimProblem problem, final Map<Integer, Double> fixing) {
        return new ConstrainedOptimSubProblem(){
            {
                1 a2;
            }

            @Override
            public LessThanConstraints getLessThanConstraints() {
                return problem.getLessThanConstraints();
            }

            @Override
            public RealScalarFunction f() {
                return problem.f();
            }

            @Override
            public Map<Integer, Double> fixing() {
                return fixing;
            }

            @Override
            public EqualityConstraints getEqualityConstraints() {
                return problem.getEqualityConstraints();
            }

            @Override
            public int dimension() {
                return problem.dimension();
            }
        };
    }

    public SubProblemMinimizer(final double gamma) {
        this((ConstrainedMinimizerFactory<? extends ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>>>)new ConstrainedMinimizerFactory<ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>>>(){

            @Override
            public ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>> newInstance() {
                return new PenaltyMethodMinimizer(gamma);
            }
            {
                3 a2;
            }
        });
    }

    public static interface ConstrainedMinimizerFactory<U extends ConstrainedMinimizer<ConstrainedOptimProblem, dev.nm.solver.IterativeSolution<Vector>>> {
        public U newInstance();
    }

    public static interface IterativeSolution<Vector>
    extends dev.nm.solver.IterativeSolution<Vector> {
        public Vector fullMinimizer();
    }
}

