/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.special;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.dense.VectorMathOperation;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;

public class Rastrigin
extends AbstractRealScalarFunction {
    private static final double new = 10.0;

    public Rastrigin(int dim) {
        super(dim);
    }

    @Override
    public Double evaluate(Vector x) {
        int a2 = this.dimensionOfDomain();
        DenseVector a3 = new DenseVector(x.size());
        for (int a4 = 1; a4 <= a2; ++a4) {
            double a5 = x.get(a4);
            double a6 = Math.PI * 2 * a5;
            double a7 = a5 * a5 - 10.0 * Math.cos(a6);
            a3.set(a4, a7);
        }
        double a8 = VectorMathOperation.sum(a3) + 10.0 * (double)a2;
        return a8;
    }
}

