/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.rn2r1.univariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.tuple.DuplicatedAbscissae;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.analysis.function.tuple.Pair;
import dev.nm.analysis.function.tuple.PairComparatorByAbscissaOnly;
import dev.nm.misc.ArgumentAssertion;
import java.util.TreeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StepFunction
extends AbstractUnivariateRealFunction
implements OrderedPairs {
    private final TreeSet<Pair> new;

    @Override
    public int size() {
        return this.new.size();
    }

    public StepFunction(double epsilon) {
        this.new = new TreeSet<Pair>(new PairComparatorByAbscissaOnly(epsilon));
    }

    public void add(OrderedPairs f2) {
        double[] a2 = f2.x();
        double[] a3 = f2.y();
        ArgumentAssertion.assertEqual(a2.length, a3.length, "x's length", "y's length");
        for (int a4 = 0; a4 < a2.length; ++a4) {
            Pair a5 = new Pair(a2[a4], a3[a4]);
            if (this.new.add(a5)) continue;
            throw new DuplicatedAbscissae(String.format("x[%d] are duplicated", a4));
        }
    }

    @Override
    public double evaluate(double x) {
        Pair a2 = this.new.floor(new Pair(x, 0.0));
        if (a2 != null) {
            return a2.y();
        }
        throw new RuntimeException(String.format("f(%f) is not defined", x));
    }

    @Override
    public double[] y() {
        double[] a2 = new double[this.new.size()];
        int a3 = 0;
        for (Pair a4 : this.new) {
            a2[a3] = a4.y();
            ++a3;
        }
        return a2;
    }

    public double maxDomain() {
        return this.new.last().x();
    }

    public StepFunction(OrderedPairs f2, double epsilon) {
        this(epsilon);
        this.add(f2);
    }

    public double minDomain() {
        return this.new.first().x();
    }

    public StepFunction(OrderedPairs f2) {
        this(f2, 0.0);
    }

    @Override
    public double[] x() {
        double[] a2 = new double[this.new.size()];
        int a3 = 0;
        for (Pair a4 : this.new) {
            a2[a3] = a4.x();
            ++a3;
        }
        return a2;
    }
}

