/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.pde.PDESolver;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDETimeSpaceGrid1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.ConvectionDiffusionEquation1D;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;

public class CrankNicolsonConvectionDiffusionEquation1D
implements PDESolver {
    public PDESolutionTimeSpaceGrid1D solve(final ConvectionDiffusionEquation1D pde, final int M2, final int N) {
        ArgumentAssertion.assertGreaterThan(M2, 0, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(N, 0, "the number of space-axis grid points");
        final double[] a2 = DoubleUtils.seq(0.0, pde.T(), M2 + 1);
        final double[] a3 = DoubleUtils.seq(0.0, pde.a(), N + 2);
        final Coefficients a4 = new Coefficients(pde, M2, N, a3);
        PDETimeSpaceGrid1D a5 = new PDETimeSpaceGrid1D(M2){

            @Override
            public void initialCondition() {
                this.u[0] = new DenseVector(N);
                for (int a22 = 1; a22 <= N; ++a22) {
                    this.u[0].set(a22, pde.f(a3[a22]));
                }
            }
            {
                1 a42;
                super(a32);
            }

            @Override
            public Vector getRHS(int m2) {
                Vector a22 = a4.getRHS(this.u[m2 - 1], a2[m2 - 1]);
                return a22;
            }

            @Override
            public TridiagonalMatrix getLHS(int m2) {
                TridiagonalMatrix a22 = a4.getLHS(a2[m2 - 1]);
                return a22;
            }
        };
        final Vector[] a6 = a5.propagate();
        return new PDESolutionTimeSpaceGrid1D(){

            @Override
            public double u(int m2, int n) {
                ArgumentAssertion.assertRange(m2, 0, M2, "m");
                ArgumentAssertion.assertRange(n, 0, N + 1, "n");
                if (n == 0 || n == N + 1) {
                    throw new UnsupportedOperationException("boundary values are not available");
                }
                return a6[m2].get(n);
            }
            {
                2 a32;
            }

            @Override
            public int M() {
                return M2;
            }

            @Override
            public double x(int n) {
                ArgumentAssertion.assertRange(n, 0, N + 1, "n");
                return a3[n];
            }

            @Override
            public double t(int m2) {
                ArgumentAssertion.assertRange(m2, 0, M2, "m");
                return a2[m2];
            }

            @Override
            public int N() {
                return N;
            }
        };
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Coefficients {
        private final double this;
        private final double else;
        private final double goto;
        private final ConvectionDiffusionEquation1D try;
        private final double[] float;
        private final double short;
        private final double enum;
        private final double false;
        private final double void;
        private final double if;
        private final int new;

        public Coefficients(ConvectionDiffusionEquation1D pde, int M2, int N, double[] x) {
            this.try = pde;
            this.new = N;
            this.float = x;
            this.else = x[1];
            this.goto = this.else / 2.0;
            this.false = pde.T() / (double)M2;
            this.enum = 0.5 * this.false / (this.else * this.else);
            this.if = pde.c1();
            this.this = pde.c2();
            this.void = 1.0 / (this.if + (1.0 - this.if) * this.else);
            this.short = 1.0 / (this.this + (1.0 - this.this) * this.else);
        }

        public Vector getRHS(Vector um, double tm) {
            double a2 = tm + 0.5 * this.false;
            double a3 = tm + this.false;
            DenseVector a4 = new DenseVector(this.new);
            double a5 = this.try.sigma(a2, this.float[1]);
            double a6 = this.try.mu(a2, this.float[1]);
            double a7 = um.get(2) * this.enum * (a5 - this.goto * a6) + um.get(1) * (1.0 - 2.0 * this.enum * a5 + this.enum * this.void * this.if * (a5 + this.goto * a6)) + this.enum * (this.try.g1(tm) + this.try.g1(a3)) * this.else * this.void * (a5 + this.goto * a6) + this.try.R(a2, this.float[1]) * this.false;
            a4.set(1, a7);
            for (int a8 = 2; a8 < this.new; ++a8) {
                double a9 = this.try.sigma(a2, this.float[a8]);
                double a10 = this.try.mu(a2, this.float[a8]);
                double a11 = um.get(a8 + 1) * this.enum * (a9 - this.goto * a10) + um.get(a8) * (1.0 - 2.0 * this.enum * a9) + um.get(a8 - 1) * this.enum * (a9 + this.goto * a10) + this.try.R(a2, this.float[a8]) * this.false;
                a4.set(a8, a11);
            }
            double a12 = this.try.sigma(a2, this.float[this.new]);
            double a13 = this.try.mu(a2, this.float[this.new]);
            double a14 = um.get(this.new) * (1.0 - 2.0 * this.enum * a12 + this.enum * this.short * this.this * (a12 - this.goto * a13)) + um.get(this.new - 1) * this.enum * (a12 + this.goto * a13) + this.enum * (this.try.g2(tm) + this.try.g2(a3)) * this.else * this.short * (a12 - this.goto * a13) + this.try.R(a2, this.float[this.new]) * this.false;
            a4.set(this.new, a14);
            return a4;
        }

        public TridiagonalMatrix getLHS(double tm) {
            double a2 = tm + 0.5 * this.false;
            double[] a3 = new double[this.new - 1];
            double[] a4 = new double[this.new];
            double[] a5 = new double[this.new - 1];
            double a6 = this.try.sigma(a2, this.float[1]);
            double a7 = this.try.mu(a2, this.float[1]);
            a4[0] = 1.0 + 2.0 * this.enum * a6 - this.enum * this.void * this.if * (a6 + this.goto * a7);
            a3[0] = this.enum * (-a6 + this.goto * a7);
            for (int a8 = 1; a8 < this.new - 1; ++a8) {
                double a9 = this.try.sigma(a2, this.float[a8 + 1]);
                double a10 = this.try.mu(a2, this.float[a8 + 1]);
                a5[a8 - 1] = -this.enum * (a9 + this.goto * a10);
                a4[a8] = 1.0 + 2.0 * this.enum * a9;
                a3[a8] = this.enum * (-a9 + this.goto * a10);
            }
            double a11 = this.try.sigma(a2, this.float[this.new]);
            double a12 = this.try.mu(a2, this.float[this.new]);
            a4[this.new - 1] = 1.0 + 2.0 * this.enum * a11 - this.enum * this.short * this.this * (a11 - this.goto * a12);
            a5[this.new - 2] = -this.enum * (a11 + this.goto * a12);
            TridiagonalMatrix a13 = new TridiagonalMatrix(new double[][]{a3, a4, a5});
            return a13;
        }
    }
}

