/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.ode.ivp.solver.extrapolation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.OLSSolver;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.UnsatisfiableErrorCriterionException;
import dev.nm.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE1stOrderWith2ndDerivative;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolution;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolver;
import dev.nm.analysis.differentiation.multivariate.Jacobian;
import dev.nm.analysis.function.rn2rm.AbstractRealVectorFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.ArgumentAssertion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SemiImplicitExtrapolation
implements ODESolver {
    private final int if;
    private final double new;

    private static RealVectorFunction char(final DerivativeFunction a2, final double a3) {
        return new AbstractRealVectorFunction(a2.dimension(), a2.dimension()){
            {
                1 a4;
                super(a22, a32);
            }

            @Override
            public Vector evaluate(Vector y) {
                return a2.evaluate(a3, y);
            }
        };
    }

    private Vector final(double a2, double a3, int a4) {
        DenseVector a5 = new DenseVector(a4);
        for (int a6 = 1; a6 <= a4; ++a6) {
            a5.set(a6, a2 + (double)a6 * a3);
        }
        return a5;
    }

    private static RealVectorFunction final(final DerivativeFunction a2, final double a3) {
        return new AbstractRealVectorFunction(a2.dimension(), a2.dimension()){

            @Override
            public Vector evaluate(Vector y) {
                return a2.evaluate(a3, y);
            }
            {
                2 a4;
                super(a22, a32);
            }
        };
    }

    public SemiImplicitExtrapolation(double epsilon, int maxIterations) {
        ArgumentAssertion.assertPositive(epsilon, "epsilon");
        ArgumentAssertion.assertNotLessThan(maxIterations, 2, "maximum number of iterations");
        this.new = epsilon;
        this.if = maxIterations;
    }

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        ArgumentAssertion.assertTrue(ode instanceof ODE1stOrderWith2ndDerivative, "this method needs the 2nd derivative of y to work", new Object[0]);
        return this.solve((ODE1stOrderWith2ndDerivative)ode);
    }

    public ODESolution solve(ODE1stOrderWith2ndDerivative ode) {
        Vector[] a2 = null;
        Vector a3 = ode.y0();
        double a4 = ode.x0();
        double a5 = ode.x1();
        OLSSolver a6 = new OLSSolver(this.new / 10.0);
        DerivativeFunction a7 = ode.dy();
        DerivativeFunction a8 = ode.ddy();
        double a9 = 0.0;
        Vector[] a10 = null;
        boolean a11 = false;
        for (int a12 = 1; a12 <= this.if; ++a12) {
            double a13;
            int a14;
            Vector[] a15 = new Vector[a12 + 1];
            int a16 = 1 << a12;
            a9 = (a5 - a4) / (double)a16;
            a10 = new Vector[a16 + 1];
            a10[0] = a3;
            Vector a17 = this.final(a4, a9, a16);
            Jacobian a18 = new Jacobian(SemiImplicitExtrapolation.char(a7, a4), a3);
            Matrix a19 = a18.ONE().minus(a18.scaled(a9));
            Vector a20 = a7.evaluate(a4, a3).scaled(a9).add(((Vector)SemiImplicitExtrapolation.final(a8, a4).evaluate(a3)).scaled(a9 * a9));
            Vector a21 = a6.solve(new LSProblem(a19, a20));
            a10[1] = a10[0].add(a21);
            for (a14 = 1; a14 < a16; ++a14) {
                a13 = a17.get(a14);
                a18 = new Jacobian(SemiImplicitExtrapolation.char(a7, a13), a10[a14]);
                a19 = a18.ONE().minus(a18.scaled(a9));
                a20 = ((Vector)SemiImplicitExtrapolation.char(a7, a13).evaluate(a10[a14])).minus(a18.multiply(a10[a14].minus(a10[a14 - 1]))).scaled(2.0 * a9);
                a21 = a6.solve(new LSProblem(a19, a20));
                a10[a14 + 1] = a10[a14 - 1].add(a21);
            }
            a18 = new Jacobian(SemiImplicitExtrapolation.char(a7, a5), a10[a16]);
            a19 = a18.ONE().minus(a18.scaled(a9));
            a20 = ((Vector)SemiImplicitExtrapolation.char(a7, a5).evaluate(a10[a16])).scaled(a9).add(((Vector)SemiImplicitExtrapolation.final(a8, a5).evaluate(a10[a16])).scaled(a9 * a9));
            a21 = a6.solve(new LSProblem(a19, a20));
            a15[1] = a10[a16 - 1].add(a10[a16]).add(a21).scaled(0.5);
            if (a12 > 1) {
                for (a14 = 2; a14 <= a12; ++a14) {
                    a13 = Math.pow(4.0, a14 - 1);
                    a15[a14] = a15[a14 - 1].scaled(a13).minus(a2[a14 - 1]).scaled(1.0 / (a13 - 1.0));
                }
                double a22 = Math.pow(4.0, a12 - 1);
                Vector a23 = a15[a12 - 1].minus(a2[a12 - 1]).scaled(1.0 / (a22 - 1.0));
                if (a23.norm() <= Math.max(a15[a12].norm(), 1.0) * this.new) {
                    a11 = true;
                    break;
                }
            }
            a2 = a15;
        }
        if (!a11) {
            throw new UnsatisfiableErrorCriterionException();
        }
        double[] a24 = new double[a10.length];
        for (int a25 = 0; a25 < a24.length; ++a25) {
            a24[a25] = a4 + (double)a25 * a9;
        }
        return new ODESolution(a24, a10);
    }
}

