/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation.bivariate;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.curvefit.interpolation.bivariate.BivariateGrid;
import dev.nm.analysis.curvefit.interpolation.bivariate.BivariateGridInterpolation;
import dev.nm.analysis.curvefit.interpolation.bivariate.BivariateInterpolationUtils;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.tuple.Triple;

public class BilinearInterpolation
implements BivariateGridInterpolation {
    @Override
    public RealScalarFunction interpolate(final BivariateGrid grid) {
        return new AbstractRealScalarFunction(2){
            {
                1 a4;
                super(a3);
            }

            @Override
            public Double evaluate(Vector coordinates) {
                double a2 = coordinates.get(1);
                double a3 = coordinates.get(2);
                Triple[][] a4 = BivariateInterpolationUtils.getSurroundingPoints(grid, a2, a3);
                double a5 = (a2 - a4[0][0].x()) / (a4[1][1].x() - a4[0][0].x());
                double a6 = (a3 - a4[0][0].y()) / (a4[1][1].y() - a4[0][0].y());
                return (1.0 - a5) * (1.0 - a6) * a4[0][0].z() + (1.0 - a5) * a6 * a4[0][1].z() + a5 * (1.0 - a6) * a4[1][0].z() + a5 * a6 * a4[1][1].z();
            }
        };
    }
}

