/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation;

import dev.nm.analysis.curvefit.interpolation.OnlineInterpolator;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.StepFunction;
import dev.nm.analysis.function.tuple.DuplicatedAbscissae;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NevilleTable
extends AbstractUnivariateRealFunction
implements OnlineInterpolator {
    private static final double short = 1.2;
    private double[] enum;
    private double false;
    private int void;
    private int if;
    private double[][] new;

    public double[][] getTable() {
        double[][] a2 = new double[this.if][this.if];
        for (int a3 = 0; a3 < this.if; ++a3) {
            for (int a4 = a3; a4 < this.if; ++a4) {
                a2[a3][a4] = this.new[a3][a4];
            }
        }
        return a2;
    }

    public double get(int i2, int j2) {
        ArgumentAssertion.assertTrue(j2 >= i2, "only the upper triangular part of the table is used", new Object[0]);
        return this.new[i2][j2];
    }

    public NevilleTable(int n, OrderedPairs f2) {
        int a2 = n;
        if (a2 < f2.size()) {
            a2 = (int)((double)f2.size() * 1.2);
        }
        this.enum = new double[a2];
        this.new = new double[a2][a2];
        this.addData(f2);
    }

    @Override
    public double evaluate(double x) {
        int a2;
        ArgumentAssertion.assertTrue(this.if >= 2, "not enough data points for interpolation", new Object[0]);
        if (this.void == this.if - 1 && this.false == x) {
            return this.new[0][this.void];
        }
        int n = a2 = this.false == x ? this.void : 1;
        while (a2 < this.if) {
            for (int a3 = a2 - 1; a3 >= 0; --a3) {
                double a4 = (x - this.enum[a2]) * this.new[a3][a2 - 1];
                a4 += (this.enum[a3] - x) * this.new[a3 + 1][a2];
                double a5 = this.enum[a3] - this.enum[a2];
                if (DoubleUtils.isZero(a5, 0.0)) {
                    throw new DuplicatedAbscissae(String.format("x[%d] and x[%d] are identical", a3, a2));
                }
                this.new[a3][a2] = a4 /= a5;
            }
            ++a2;
        }
        this.false = x;
        this.void = this.if - 1;
        return this.new[0][this.void];
    }

    @Override
    public void addData(OrderedPairs f2) {
        int a2;
        double[] a3 = f2.x();
        double[] a4 = f2.y();
        int a5 = a3.length;
        if (this.if + a5 > this.new.length) {
            a2 = (int)((double)(this.if + a5) * 1.2);
            double[] a6 = new double[a2];
            for (int a7 = 0; a7 < this.if; ++a7) {
                a6[a7] = this.enum[a7];
            }
            this.enum = a6;
            double[][] a8 = new double[a2][a2];
            for (int a9 = 0; a9 < this.if; ++a9) {
                for (int a10 = a9; a10 < this.if; ++a10) {
                    a8[a9][a10] = this.new[a9][a10];
                }
            }
            this.new = a8;
        }
        a2 = this.if;
        for (int a11 = 0; a11 < a5; ++a11) {
            this.enum[a2] = a3[a11];
            this.new[a2][a2] = a4[a11];
            ++a2;
        }
        this.if += a5;
    }

    public NevilleTable(OrderedPairs f2) {
        this(0, f2);
    }

    public int N() {
        return this.if;
    }

    public NevilleTable() {
        this(10, new StepFunction(0.0));
    }

    public double[] x() {
        double[] a2 = Arrays.copyOf(this.enum, this.if);
        return a2;
    }
}

