/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DiagonalSum
implements Matrix {
    private final Matrix new;

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        return this.new.get(i2, j2);
    }

    @Override
    public Matrix multiply(Matrix that) {
        return this.new.multiply(that);
    }

    @Override
    public Matrix ZERO() {
        return this.new.ZERO();
    }

    @Override
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        this.new.set(i2, j2, value);
    }

    @Override
    public int nCols() {
        return this.new.nCols();
    }

    public DiagonalSum(Matrix A2, double d2) {
        this(A2, DoubleUtils.rep(d2, A2.nCols()));
    }

    @Override
    public Matrix opposite() {
        return this.new.opposite();
    }

    @Override
    public Matrix ONE() {
        return this.new.ONE();
    }

    @Override
    public Matrix t() {
        return this.new.t();
    }

    @Override
    public Matrix scaled(double c2) {
        return this.new.scaled(c2);
    }

    @Override
    public Matrix deepCopy() {
        return this.new.deepCopy();
    }

    public DiagonalSum(Matrix A2, double[] d2) {
        ArgumentAssertion.assertTrue(A2.nCols() == A2.nRows(), "A must be a square matrix", new Object[0]);
        ArgumentAssertion.assertTrue(A2.nCols() == d2.length, "A and d dimensions must match", new Object[0]);
        Matrix a2 = A2.deepCopy();
        int a3 = A2.nCols();
        for (int a4 = 1; a4 <= a3; ++a4) {
            double a5 = A2.get(a4, a4) + d2[a4 - 1];
            a2.set(a4, a4, a5);
        }
        this.new = a2;
    }

    @Override
    public Vector getRow(int i2) throws MatrixAccessException {
        return this.new.getRow(i2);
    }

    @Override
    public Vector multiply(Vector v) {
        return this.new.multiply(v);
    }

    @Override
    public Matrix add(Matrix that) {
        return this.new.add(that);
    }

    @Override
    public int nRows() {
        return this.new.nRows();
    }

    public DiagonalSum(Matrix A2, Vector d2) {
        this(A2, d2.toArray());
    }

    @Override
    public Matrix minus(Matrix that) {
        return this.new.minus(that);
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        return this.new.getColumn(j2);
    }
}

