/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SORSweep {
    private final Vector false;
    private final int void;
    private final double if;
    private final Matrix new;

    public SORSweep(Matrix A2, Vector b2, double omega) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "A must be a square matrix", new Object[0]);
        SORSweep.final(A2);
        this.new = A2;
        this.false = b2;
        this.void = A2.nCols();
        this.if = omega;
    }

    private static void final(Matrix a2) {
        for (int a3 = 1; a3 <= a2.nCols(); ++a3) {
            if (Double.compare(a2.get(a3, a3), 0.0) != 0) continue;
            throw new IllegalArgumentException("diagonal entries must be non-zero");
        }
    }

    public Vector backward(Vector x) {
        Vector a2 = new DenseVector(this.void).ZERO();
        for (int a3 = this.void; a3 >= 1; --a3) {
            int a4;
            double a5 = 0.0;
            for (a4 = 1; a4 < a3; ++a4) {
                a5 += this.new.get(a3, a4) * x.get(a4);
            }
            for (a4 = a3 + 1; a4 <= this.void; ++a4) {
                a5 += this.new.get(a3, a4) * a2.get(a4);
            }
            a5 = (this.false.get(a3) - a5) / this.new.get(a3, a3);
            a5 = x.get(a3) + this.if * (a5 - x.get(a3));
            a2.set(a3, a5);
        }
        return a2;
    }

    public Vector forward(Vector x) {
        Vector a2 = new DenseVector(this.void).ZERO();
        for (int a3 = 1; a3 <= this.void; ++a3) {
            int a4;
            double a5 = 0.0;
            for (a4 = 1; a4 < a3; ++a4) {
                a5 += this.new.get(a3, a4) * a2.get(a4);
            }
            for (a4 = a3 + 1; a4 <= this.void; ++a4) {
                a5 += this.new.get(a3, a4) * x.get(a4);
            }
            a5 = (this.false.get(a3) - a5) / this.new.get(a3, a3);
            a5 = x.get(a3) + this.if * (a5 - x.get(a3));
            a2.set(a3, a5);
        }
        return a2;
    }
}

