/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Cholesky;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyBanachiewicz;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyBanachiewiczParallelized;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskySparse;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Chol
implements Cholesky {
    private Cholesky new;

    public Chol(Matrix A2) {
        this(A2, 0.0);
    }

    public UpperTriangularMatrix Lt() {
        return this.L().t();
    }

    public Chol(Matrix A2, double epsilon) {
        if (!MatrixPropertyUtils.isSymmetric(A2, epsilon)) {
            throw new IllegalArgumentException("Cholesky decomposition applies to only symmetric matrix");
        }
        this.final(A2);
    }

    @Override
    public LowerTriangularMatrix L() {
        return this.new.L();
    }

    public Chol(Matrix A2, boolean isSymmetric) {
        if (!isSymmetric && !MatrixPropertyUtils.isSymmetric(A2, 0.0)) {
            throw new IllegalArgumentException("Cholesky decomposition applies to only symmetric matrix");
        }
        this.final(A2);
    }

    private void final(Matrix a2) {
        a.new = a2 instanceof SparseMatrix ? new CholeskySparse(a2) : (CholeskyBanachiewiczParallelized.shouldUseParallel(a2.nRows()) ? new CholeskyBanachiewiczParallelized(a2) : new CholeskyBanachiewicz(a2));
    }
}

