/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.EigenvalueExtracter;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.HessenbergReduction;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.SchurTransformation;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class QRAlgorithmSkeleton {
    private final EigenvalueExtracter void;
    private final HessenbergReduction if;
    private final SchurTransformation new;

    QRAlgorithmSkeleton(HessenbergReduction a2, SchurTransformation a3, EigenvalueExtracter a4) {
        QRAlgorithmSkeleton a5;
        a5.if = a2;
        a5.new = a3;
        a5.void = a4;
    }

    public Result process(Matrix A2) {
        final HessenbergReduction.HessenbergDecomposition a2 = this.if.reduce(A2);
        final Matrix a3 = a2.H();
        final SchurTransformation.SchurDecomposition a4 = this.new.transform(a3);
        final Matrix a5 = a4.T();
        return new Result(){
            private ImmutableMatrix if;
            private List<? extends Number> new;

            @Override
            public ImmutableMatrix H() {
                return new ImmutableMatrix(a3);
            }

            @Override
            public HessenbergReduction.HessenbergDecomposition getHessenbergDecomposition() {
                return a2;
            }

            @Override
            public List<? extends Number> getEigenvalues() {
                if (this.new == null) {
                    this.new = QRAlgorithmSkeleton.this.void.extract(a5);
                }
                return Collections.unmodifiableList(this.new);
            }
            {
                1 a32;
            }

            @Override
            public ImmutableMatrix Q() {
                if (this.if == null) {
                    this.if = new ImmutableMatrix(a2.Q().multiply(a4.Q()));
                }
                return this.if;
            }

            @Override
            public ImmutableMatrix T() {
                return new ImmutableMatrix(a5);
            }

            @Override
            public SchurTransformation.SchurDecomposition getRealSchurCanonicalFormDecomposition() {
                return a4;
            }
        };
    }

    static interface Result {
        public HessenbergReduction.HessenbergDecomposition getHessenbergDecomposition();

        public ImmutableMatrix H();

        public ImmutableMatrix T();

        public ImmutableMatrix Q();

        public SchurTransformation.SchurDecomposition getRealSchurCanonicalFormDecomposition();

        public List<? extends Number> getEigenvalues();
    }
}

