/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.BlockRootRepresentation;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.BlockVector;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.EigenInfo;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.EigenvalueRefinementForInitialBlock;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.SymmetricEigenFor2x2Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.TestForPreservingRelativeAccuracy;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.UnreducedBlock;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MR3
implements Spectrum {
    private static final double break;
    private final List<Double> const;
    private final boolean this;
    private Vector else;
    private static final double goto;
    private static final double try;
    private final int float;
    private static final double short;
    private final double enum;
    private final List<Vector> false;
    private Vector void;
    public static final double DEFAULT_MIN_RELATIVE_GAP = 0.001;
    private static final double if;
    private static final double new;

    private void void() {
        MR3 a2;
        SymmetricEigenFor2x2Matrix a3 = new SymmetricEigenFor2x2Matrix(a2.void.get(1), a2.else.get(1), a2.void.get(2));
        a2.const.addAll(a3.getEigenvalues());
        if (a2.this) {
            a2.false.addAll(a3.getEigenvectors());
        }
    }

    public MR3(Vector D2, Vector E2, boolean wantEigenvector, double minRelativeGap) {
        ArgumentAssertion.assertTrue(D2.size() == 1 || D2.size() == E2.size() + 1, "D's size must be greater than E's size by 1", new Object[0]);
        this.void = D2.deepCopy();
        this.else = E2 != null ? E2.deepCopy() : null;
        this.this = wantEigenvector;
        this.enum = minRelativeGap;
        this.float = D2.size();
        this.const = new ArrayList<Double>(this.float);
        this.false = new ArrayList<Vector>(this.float);
        if (this.float <= 2) {
            this.do();
        } else {
            this.char();
        }
        this.break();
    }

    private void final(UnreducedBlock[] a2, double a3, double a4) {
        for (UnreducedBlock a5 : a2) {
            if (a5.size < 1) continue;
            double a6 = 4.0 * goto;
            EigenvalueRefinementForInitialBlock a7 = new EigenvalueRefinementForInitialBlock(a5, a6, a3, a4);
            a7.compute();
        }
    }

    static {
        goto = Constants.MACH_EPS;
        short = 5.562684646268003E-309 * (1.0 + goto);
        try = short / goto;
        new = 1.0 / try;
        if = Math.sqrt(try);
        break = Math.min(Math.sqrt(new), 1.0 / Math.sqrt(Math.sqrt(short)));
    }

    private double final(double a2) {
        double a3 = 1.0;
        if (a2 > 0.0 && a2 < if) {
            a3 = if / a2;
        } else if (a2 > break) {
            a3 = break / a2;
        }
        if (a3 != 1.0) {
            MR3 a4;
            a4.void = a4.void.scaled(a3);
            a4.else = a4.else.scaled(a3);
        }
        return a3;
    }

    private void goto() {
        MR3 a2;
        if (!a2.this) {
            throw new UnsupportedOperationException("eigenvectors were not computed");
        }
    }

    private void final(UnreducedBlock[] a2) {
        for (UnreducedBlock a3 : a2) {
            for (EigenInfo a4 : a3.getEigenInfoList()) {
                MR3 a5;
                a5.const.add(a4.getEigenvalue());
            }
        }
    }

    private void break() {
        MR3 a2;
        if (!a2.this) {
            Collections.sort(a2.const, Collections.reverseOrder());
        } else {
            int a3;
            ArrayList<EigenPair> a4 = new ArrayList<EigenPair>(a2.float);
            for (a3 = 0; a3 < a2.float; ++a3) {
                a4.add(new EigenPair(a2.const.get(a3), a2.false.get(a3)));
            }
            Collections.sort(a4, new Comparator<EigenPair>(){
                {
                    1 a3;
                }

                @Override
                public int compare(EigenPair pair1, EigenPair pair2) {
                    return -Double.compare(pair1.if, pair2.if);
                }
            });
            for (a3 = 0; a3 < a2.float; ++a3) {
                EigenPair a5 = (EigenPair)a4.get(a3);
                a2.const.set(a3, a5.if);
                a2.false.set(a3, a5.new);
            }
        }
    }

    private void do() {
        MR3 a2;
        switch (a2.float) {
            case 0: {
                throw new IllegalArgumentException("dimension of the input matrix is zero");
            }
            case 1: {
                a2.final();
                break;
            }
            case 2: {
                a2.void();
            }
        }
    }

    private void char() {
        MR3 a2;
        double a3 = a2.final(a2.void, a2.else);
        double a4 = a2.final(a3);
        double a5 = a4 * a3;
        TestForPreservingRelativeAccuracy a6 = new TestForPreservingRelativeAccuracy();
        boolean a7 = a6.canPreserveRelativeAccuracy(a2.void, a2.else);
        double a8 = a7 ? goto : -goto;
        double a9 = a2.final(a2.else);
        BlockRootRepresentation a10 = new BlockRootRepresentation(a2.void, a2.else, a8, a9);
        double a11 = a10.getEigenLowerBound();
        UnreducedBlock[] a12 = a10.getUnreducedBlocks();
        if (a2.this) {
            BlockVector a13 = new BlockVector(a2.float, a11, a9, a2.enum);
            a2.false.addAll(a13.computeEigenvectors(a12));
        }
        if (a7) {
            a2.final(a12, a9, a5);
        }
        a2.final(a12);
        a2.final(a4);
    }

    private double final(Vector a2) {
        double a3 = a2.norm(Double.POSITIVE_INFINITY);
        double a4 = Math.max(1.0, a3 * a3) * short;
        return a4;
    }

    public List<Double> getEigenvalues() {
        return new ArrayList<Double>(this.const);
    }

    private void final(double a2) {
        if (a2 != 1.0) {
            MR3 a3;
            for (int a4 = 0; a4 < a3.const.size(); ++a4) {
                double a5 = a3.const.get(a4);
                a3.const.set(a4, a5 / a2);
            }
        }
    }

    public List<Vector> getEigenvectors() {
        this.goto();
        return Collections.unmodifiableList(this.false);
    }

    public MR3(Vector D2, Vector E2) {
        this(D2, E2, true, 0.001);
    }

    private double final(Vector a2, Vector a3) {
        return Math.max(a2.norm(Double.POSITIVE_INFINITY), a3.norm(Double.POSITIVE_INFINITY));
    }

    public Matrix getEigenvectorMatrix() {
        this.goto();
        return MatrixFactory.cbind(this.false);
    }

    private void final() {
        MR3 a2;
        a2.const.add(a2.void.get(1));
        if (a2.this) {
            a2.false.add(new DenseVector(1.0));
        }
    }

    public MR3(Vector D2, Vector E2, boolean wantEigenvector) {
        this(D2, E2, wantEigenvector, 0.001);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class EigenPair {
        private final double if;
        private final Vector new;

        private EigenPair(double a2, Vector a3) {
            EigenPair a4;
            a4.if = a2;
            a4.new = a3;
        }
    }
}

