/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.ComplexEigenvalueComparator;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenProperty;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorByLookup;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorBySystemOfEquations;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorProvider;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.RealEigenvalueComparator;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.SymmetricEigenByMR3;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.QRAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.SymmetricQRAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.number.DoubleUtils;
import dev.nm.number.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Eigen
implements Spectrum {
    private final boolean void;
    private final double if;
    private final SortedMap<Number, EigenProperty> new;

    private static boolean final(List<Number> a2) {
        for (Number a3 : a2) {
            if (NumberUtils.isReal(a3)) continue;
            return false;
        }
        return true;
    }

    public EigenProperty getProperty(Number eigenvalue) {
        return (EigenProperty)this.new.get(eigenvalue);
    }

    public Eigen(Matrix A2, double epsilon) {
        this(A2, Method.QR, epsilon);
    }

    public double[] getRealEigenvalues() {
        if (this.void) {
            return DoubleUtils.collection2DoubleArray(this.new.keySet());
        }
        ArrayList<Number> a2 = new ArrayList<Number>();
        for (Number a3 : this.new.keySet()) {
            if (!NumberUtils.isReal(a3)) continue;
            a2.add(a3);
        }
        Collections.sort(a2, new RealEigenvalueComparator(this.if));
        return DoubleUtils.collection2DoubleArray(a2);
    }

    public Eigen(Matrix A2, Method method) {
        this(A2, method, PrecisionUtils.autoEpsilon(A2));
    }

    public Eigen(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    private Map.Entry<Number, EigenProperty> final(int a2) {
        Eigen a3;
        Iterator<Map.Entry<Number, EigenProperty>> a4 = a3.new.entrySet().iterator();
        for (int a5 = 0; a5 < a2; ++a5) {
            a4.next();
        }
        return a4.next();
    }

    public List<Number> getEigenvalues() {
        ArrayList<Number> a2 = new ArrayList<Number>(this.new.keySet());
        return a2;
    }

    public Number getEigenvalue(int i2) {
        return this.final(i2).getKey();
    }

    /*
     * WARNING - void declaration
     */
    public Eigen(Matrix A2, Method method, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "eigen decomposition applies only to square matrix", new Object[0]);
        EigenProvider a2 = method.newProvider(A2, epsilon);
        Spectrum a3 = a2.getSpectrum();
        List<Number> a4 = a3.getEigenvalues();
        this.void = Eigen.final(a4);
        Comparator<Number> a5 = this.void ? new RealEigenvalueComparator(epsilon) : new ComplexEigenvalueComparator(epsilon);
        TreeMap<Number, Integer> a6 = new TreeMap<Number, Integer>(a5);
        for (Number a7 : a4) {
            void var12_11;
            Integer n = (Integer)a6.get(a7);
            if (n == null) {
                Integer n2 = 0;
            }
            a6.put(a7, var12_11.intValue() + 1);
        }
        this.new = new TreeMap<Number, EigenProperty>(a5);
        EigenvectorProvider a9 = a2.getEigenvectorProvider();
        for (Map.Entry entry : a6.entrySet()) {
            Number a10 = (Number)entry.getKey();
            Integer a11 = (Integer)entry.getValue();
            this.new.put(a10, new EigenProperty(a10, a11, a9));
        }
        this.if = epsilon;
    }

    public EigenProperty getProperty(int i2) {
        return this.final(i2).getValue();
    }

    public int size() {
        return this.new.size();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        CHARACTERISTIC_POLYNOMIAL{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                1 a4;
                return new EigenProvider(){
                    private final EigenvectorProvider if;
                    private final Spectrum new;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.new;
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.if;
                    }
                    {
                        Method.1 a32;
                        a32.new = new CharacteristicPolynomial(a32.a2);
                        a32.if = new EigenvectorBySystemOfEquations(a32.a2, a32.a3);
                    }
                };
            }
            {
                1 a2;
            }
        }
        ,
        MR3{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                2 a4;
                return new EigenProvider(){
                    private final SymmetricEigenByMR3 if;
                    private final EigenvectorProvider new;
                    {
                        Method.1 a32;
                        a32.if = new SymmetricEigenByMR3(a32.a2, true, a32.a3);
                        a32.new = new EigenvectorByLookup(a32.if.getEigenvalues(), new EigenvectorByLookup.EigenvectorListProvider(){

                            @Override
                            public List<Vector> getAllEigenvectors() {
                                return a32.if.getEigenvectors();
                            }
                            {
                                Method.1 a3;
                            }
                        }, a32.a3);
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.new;
                    }

                    @Override
                    public Spectrum getSpectrum() {
                        return this.if;
                    }
                };
            }
            {
                2 a2;
            }
        }
        ,
        QR_SYMMETRIC{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                3 a4;
                return new EigenProvider(){
                    private final SymmetricQRAlgorithm if;
                    private final EigenvectorProvider new;
                    {
                        Method.1 a32;
                        a32.if = new SymmetricQRAlgorithm(a32.a2, a32.a3);
                        a32.new = new EigenvectorByLookup(a32.if.getEigenvalues(), new EigenvectorByLookup.EigenvectorListProvider(){

                            @Override
                            public List<Vector> getAllEigenvectors() {
                                return a32.if.getEigenvectors();
                            }
                            {
                                Method.1 a3;
                            }
                        }, a32.a3);
                    }

                    @Override
                    public Spectrum getSpectrum() {
                        return this.if;
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.new;
                    }
                };
            }
            {
                3 a2;
            }
        }
        ,
        SYMMETRY{

            @Override
            EigenProvider newProvider(Matrix a2, double a3) {
                return MR3.newProvider(a2, a3);
            }
            {
                4 a2;
            }
        }
        ,
        QR{
            {
                5 a2;
            }

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                5 a4;
                if (MatrixPropertyUtils.isSymmetric(a2, 0.0)) {
                    Matrix a5 = a2 instanceof SymmetricMatrix ? a2 : new SymmetricMatrix(a2, true);
                    return QR_SYMMETRIC.newProvider(a5, a3);
                }
                return new EigenProvider(){
                    private final Spectrum if;
                    private final EigenvectorProvider new;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.if;
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.new;
                    }
                    {
                        Method.1 a32;
                        a32.if = new QRAlgorithm(a32.a2, a32.a3);
                        a32.new = new EigenvectorBySystemOfEquations(a32.a2, a32.a3);
                    }
                };
            }
        };


        private Method() {
            Method a2;
        }

        abstract EigenProvider newProvider(Matrix var1, double var2);
    }

    private static interface EigenProvider {
        public EigenvectorProvider getEigenvectorProvider();

        public Spectrum getSpectrum();
    }
}

