/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.markowitz;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.positivedefinite.PositiveDefiniteMatrixByPositiveDiagonal;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.QuadraticFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearGreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPInfeasible;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPSimpleMinimizer;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPSolution;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.problem.QPProblem;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.solver.socp.QPbySOCPMinimizer;
import dev.nm.solver.univariate.GridSearchMinimizer;
import dev.nm.solver.univariate.UnivariateMinimizer;
import dev.nm.solver.univariate.bracketsearch.BrentMinimizer;
import tech.nmfin.portfoliooptimization.PortfolioUtils;
import tech.nmfin.portfoliooptimization.markowitz.constraints.QPConstraint;
import tech.nmfin.portfoliooptimization.markowitz.constraints.QPUnity;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MarkowitzByQP {
    private double else = Double.NaN;
    private final double goto;
    private final LinearEqualityConstraints try;
    private final Matrix float;
    private final LinearLessThanConstraints short;
    private final double enum;
    private final LinearGreaterThanConstraints false;
    private Vector void;
    private final UnivariateRealFunction if = new AbstractUnivariateRealFunction(){

        @Override
        public double evaluate(double q) {
            double a2;
            try {
                Vector a3 = MarkowitzByQP.this.getOptimalW(q);
                a2 = PortfolioUtils.getSharpeRatio(a3, MarkowitzByQP.this.new, MarkowitzByQP.this.float, MarkowitzByQP.this.goto);
            }
            catch (Exception a4) {
                a2 = Double.NEGATIVE_INFINITY;
            }
            return -a2;
        }
        {
            1 a3;
        }
    };
    private final Vector new;

    public double getRiskAversionCoefficientForTargetReturn(final double r, double lower, double upper, int maxIterations) throws NoRootFoundException {
        AbstractUnivariateRealFunction a2 = new AbstractUnivariateRealFunction(){
            {
                2 a3;
            }

            @Override
            public double evaluate(double q) {
                double a2;
                try {
                    Vector a3 = MarkowitzByQP.this.getOptimalW(q);
                    double a4 = PortfolioUtils.getPortfolioReturns(a3, MarkowitzByQP.this.new);
                    a2 = a4 - r;
                }
                catch (Exception a5) {
                    a2 = Double.NEGATIVE_INFINITY;
                }
                return a2;
            }
        };
        BrentRoot a3 = new BrentRoot(this.enum, maxIterations);
        double a4 = a3.solve(a2, lower, upper, r);
        return a4;
    }

    public MarkowitzByQP(Vector mu, Matrix sigma) {
        this(mu, sigma, new DenseVector(mu.size(), 0.0), new DenseVector(mu.size(), 1.01));
    }

    public double getOptimalRiskAversionCoefficient() {
        double a2 = 1.0E-6;
        double a3 = 10.0;
        int a4 = 50;
        double a5 = (a3 - a2) / (double)a4;
        GridSearchMinimizer a6 = new GridSearchMinimizer(a4);
        GridSearchMinimizer.Solution a7 = a6.solve(this.if);
        double a8 = a7.search(a2, a3);
        try {
            if (DoubleUtils.compare(a8, a2, a5 / 2.0) == 0) {
                return a2;
            }
            if (DoubleUtils.compare(a8, a3, a5 / 2.0) == 0) {
                return a3;
            }
            return this.getOptimalRiskAversionCoefficient(a2, a8, a3);
        }
        catch (Exception a9) {
            return a8;
        }
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, Vector lower, Vector upper) {
        this(mu, sigma, lower, upper, 0.0);
    }

    protected Vector getOptimalW(double q) throws Exception {
        return this.final(q);
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, QPConstraint constraints, double benchmarkRate) {
        this.enum = 100.0 * PrecisionUtils.autoEpsilon(sigma);
        this.new = new ImmutableVector(mu);
        this.float = new ImmutableMatrix(sigma);
        this.goto = benchmarkRate;
        this.false = constraints.linearGreaterThanConstraints();
        this.short = constraints.linearLessThanConstraints();
        LinearEqualityConstraints a2 = constraints.linearEqualityConstraints();
        LinearEqualityConstraints a3 = new QPUnity(mu.size()).linearEqualityConstraints();
        this.try = a2 != null ? (LinearEqualityConstraints)LinearConstraints.concat(a3, a2) : a3;
    }

    public double fw() {
        Matrix a2 = this.float.scaled(2.0 * this.else);
        Vector a3 = this.new.scaled(-1.0);
        QuadraticFunction a4 = new QuadraticFunction(a2, a3);
        double a5 = a4.evaluate(this.void);
        return a5;
    }

    public void setRiskAversionCoefficient(double q) throws QPInfeasible, Exception {
        this.else = q;
        this.void = new ImmutableVector(this.getOptimalW(q));
    }

    private Vector final(double a2) throws Exception {
        MarkowitzByQP a3;
        Matrix a4;
        Matrix a5 = a4 = a3.float.scaled(2.0 * a2);
        double a6 = PrecisionUtils.autoEpsilon(a4);
        if (!MatrixPropertyUtils.isPositiveDefinite(a4, a6)) {
            a5 = new PositiveDefiniteMatrixByPositiveDiagonal(a4, a6, a6);
        }
        Vector a7 = a3.new.scaled(-1.0);
        QuadraticFunction a8 = new QuadraticFunction(a5, a7);
        if (a3.false == null && a3.short == null) {
            return QPSimpleMinimizer.solve(a8, a3.try, a6).minimizer();
        }
        QPProblem a9 = new QPProblem(a8, a3.try, a3.false, a3.short);
        QPbySOCPMinimizer a10 = new QPbySOCPMinimizer(a6, 10000);
        IterativeSolution a11 = (IterativeSolution)a10.solve(a9);
        QPSolution a12 = a11.search(new QPSolution[0]);
        return a12.minimizer();
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, QPConstraint constraints) {
        this(mu, sigma, constraints, 0.0);
    }

    public double getRiskAversionCoefficientForTargetVariance(final double var, double lower, double upper, int maxIterations) throws NoRootFoundException {
        AbstractUnivariateRealFunction a2 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double q) {
                double a2;
                try {
                    Vector a3 = MarkowitzByQP.this.getOptimalW(q);
                    double a4 = PortfolioUtils.getPortfolioVariance(a3, MarkowitzByQP.this.float);
                    a2 = a4 - var;
                }
                catch (Exception a5) {
                    a2 = Double.NEGATIVE_INFINITY;
                }
                return a2;
            }
            {
                3 a3;
            }
        };
        BrentRoot a3 = new BrentRoot(this.enum, maxIterations);
        double a4 = a3.solve(a2, lower, upper, var);
        return a4;
    }

    public double getOptimalRiskAversionCoefficient(double lower, double initial, double upper) throws Exception {
        BrentMinimizer a2 = new BrentMinimizer(1.0E-15, 4);
        UnivariateMinimizer.Solution a3 = a2.solve(this.if);
        double a4 = a3.search(lower, initial, upper);
        return a4;
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, Vector lower, Vector upper, double benchmarkRate) {
        LinearEqualityConstraints a2;
        this.enum = 100.0 * PrecisionUtils.autoEpsilon(sigma);
        this.new = new ImmutableVector(mu);
        this.float = new ImmutableMatrix(sigma);
        this.goto = benchmarkRate;
        int a3 = mu.size();
        CSRSparseMatrix a4 = new CSRSparseMatrix(a3, a3).ONE();
        this.false = new LinearGreaterThanConstraints(a4, lower);
        this.short = new LinearLessThanConstraints(a4, upper);
        this.try = a2 = new QPUnity(mu.size()).linearEqualityConstraints();
    }

    public Vector getOptimalWeights() {
        return this.void;
    }
}

