/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.clm;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.number.DoubleUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import tech.nmfin.portfoliooptimization.clm.MarkowitzCriticalLine;
import tech.nmfin.portfoliooptimization.clm.MarkowitzCriticalLineUtils;
import tech.nmfin.portfoliooptimization.clm.TurningPoint;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MCLNiedermayer
implements MarkowitzCriticalLine {
    private final ImmutableVector this;
    private final ImmutableVector else;
    private final int goto;
    private final ImmutableVector try;
    private boolean float = false;
    private final Vector[] short;
    private final ImmutableMatrix enum;
    private final List<TurningPoint> false = new ArrayList<TurningPoint>();
    private final int void;
    private final double if = 1.0E-8;
    private boolean new = false;

    private double final(Vector a2, double a3, double a4, double a5, Vector a6, double a7) {
        double a8 = a3;
        double a9 = a7 - a6.innerProduct(a2);
        double a10 = a8 * a4 - a9 * a5;
        return a10;
    }

    private InitialWeight final(Vector a2, Vector a3) throws Exception {
        DenseVector a4 = new DenseVector(a2);
        DenseVector a5 = new DenseVector(a2.size(), 1.0);
        double a6 = a4.innerProduct((Vector)a5);
        if (DoubleUtils.compare(a6, 1.0, 1.0E-8) > 0) {
            throw new Exception("no possible weight vector found");
        }
        for (int a7 = 1; a7 <= a4.size(); ++a7) {
            if (1.0 - a6 < a3.get(a7) - a2.get(a7)) {
                double a8 = a4.get(a7);
                a4.set(a7, a8 + 1.0 - a6);
                Integer a9 = a7;
                return new InitialWeight(a4, a9);
            }
            a4.set(a7, a3.get(a7));
            a6 += a3.get(a7) - a2.get(a7);
        }
        throw new Exception("no possible weight vector!");
    }

    private Vector final(Vector a2, int[] a3, ImmutableVector a4, ImmutableVector a5) {
        DenseVector a6 = new DenseVector(a2.size(), 0.0);
        for (int a7 = 1; a7 <= a2.size(); ++a7) {
            if (a2.get(a7) > 0.0) {
                a6.set(a7, a5.get(a3[a7 - 1]));
                continue;
            }
            a6.set(a7, a4.get(a3[a7 - 1]));
        }
        return a6;
    }

    private int final(Vector a2, double a3) {
        double a4 = Double.NEGATIVE_INFINITY;
        int a5 = 1;
        boolean a6 = true;
        for (int a7 = 1; a7 <= a2.size(); ++a7) {
            if (!(a2.get(a7) < a3) || !(a4 < a2.get(a7))) continue;
            a5 = a7;
            a4 = a2.get(a7);
            a6 = false;
        }
        if (a6) {
            return 0;
        }
        return a5;
    }

    private Vector final(Vector a2, Vector a3, double a4, double a5) {
        return a2.scaled(-a4).add(a3.scaled(a5));
    }

    private Vector final(double a2, Vector a3, Vector a4, Vector a5, double a6, double a7, double a8, double a9, int[] a10, Vector a11) {
        MCLNiedermayer a12;
        Vector a13 = a12.final(a3, a4, a5, a6, a7, a8, a9, a2);
        return a12.final(a13, a11, a10);
    }

    private int[] char(int[] a2, int a3) {
        int[] a4 = new int[a2.length + 1];
        System.arraycopy(a2, 0, a4, 0, a2.length);
        a4[a2.length] = a3;
        return a4;
    }

    private Vector final(Vector a2, Vector a3, int[] a4) {
        DenseVector a5 = new DenseVector(a3);
        for (int a6 = 0; a6 < a4.length; ++a6) {
            a5.set(a4[a6], a2.get(a6 + 1));
        }
        return a5;
    }

    @Override
    public Vector getOptimalWeightForTargetReturn(double target) throws Exception {
        List<TurningPoint> a2 = this.new ? this.getTurningPoints() : this.final((TurningPoint a3) -> a3.mu() <= target);
        int a4 = a2.size();
        for (int a5 = 0; a5 < a4 - 1; ++a5) {
            TurningPoint a6 = a2.get(a5);
            TurningPoint a7 = a2.get(a5 + 1);
            if (!(target >= a6.mu()) || !(target <= a7.mu())) continue;
            double a8 = MarkowitzCriticalLineUtils.getProportion(target, a6.mu(), a7.mu());
            return a6.weight().scaled(a8).add(a7.weight().scaled(1.0 - a8));
        }
        throw new Exception("impossible target gain: " + target);
    }

    private /* synthetic */ AbstractMap.SimpleImmutableEntry final(int[] a2, int[] a3, Vector a4, Vector a5, double a6, double a7, double a8, Vector a9, Vector a10, int a11) {
        MCLNiedermayer a12;
        Vector a13 = a12.final(a11);
        Vector a14 = VectorFactory.subVector(a13, a2);
        double a15 = a12.this.get(a11);
        Vector a16 = VectorFactory.subVector(a13, a3);
        double a17 = 1.0 - a14.innerProduct(a4);
        double a18 = a12.final(a5, a17, a6, a7, a14, a15);
        double a19 = a12.final(a8, a17, a9, a7, a10, a16, a14, a18);
        return new AbstractMap.SimpleImmutableEntry<Integer, Double>(a11, a19);
    }

    private Vector final(Vector a2, Vector a3, Vector a4, double a5, double a6, double a7, double a8, double a9) {
        double a10 = (-a9 * a7 + 1.0 - a5 + a8) / a6;
        Vector a11 = a2.scaled(a10).add(a3.scaled(a9)).minus(a4);
        return a11;
    }

    public MCLNiedermayer(Vector gain, Matrix covariance, Vector lower, Vector upper) {
        this.this = new ImmutableVector(gain);
        this.goto = gain.size();
        this.enum = new ImmutableMatrix(covariance);
        this.short = MatrixUtils.toRows(this.enum);
        this.void = 10 * gain.size() * gain.size();
        this.try = new ImmutableVector(lower);
        this.else = new ImmutableVector(upper);
    }

    private Vector final(int a2) {
        MCLNiedermayer a3;
        return a3.short[a2 - 1];
    }

    private List<TurningPoint> final(Predicate<TurningPoint> a4) throws Exception {
        int a5;
        MCLNiedermayer a6;
        ArrayList<TurningPoint> a7 = new ArrayList<TurningPoint>();
        int[] a8 = new int[1];
        BitSet a9 = new BitSet();
        InitialWeight a10 = a6.final();
        Vector a11 = a10.if;
        a8[0] = a10.new;
        a9.set((int)a10.new, true);
        double a12 = Double.POSITIVE_INFINITY;
        Matrix a13 = new Inverse(MatrixFactory.subMatrix((Matrix)a6.enum, a8, a8));
        TurningPoint a14 = null;
        for (a5 = 0; !(a5 >= a6.void || a14 != null && a4.test(a14)); ++a5) {
            Vector a15;
            Vector a16;
            Object a17;
            int a18;
            int a19 = -1;
            int a20 = 0;
            int a21 = 0;
            double a22 = Double.POSITIVE_INFINITY;
            double a23 = Double.NEGATIVE_INFINITY;
            Vector a24 = VectorFactory.subVector((Vector)a6.this, a8);
            int[] a25 = a6.final(a9);
            Vector a26 = a6.final(a11, a25);
            Matrix a27 = a6.final(a6.enum, a8, a25);
            Vector a28 = a27.multiply(a26);
            DenseVector a29 = new DenseVector(a24.size(), 1.0);
            DenseVector a30 = new DenseVector(a26.size(), 1.0);
            double a31 = a30.innerProduct(a26);
            Vector a32 = a13.multiply(a24);
            double a33 = a29.innerProduct(a32);
            Vector a34 = a13.multiply(a29);
            double a35 = a29.innerProduct(a34);
            Vector a36 = a13.multiply(a28);
            double a37 = a29.innerProduct(a36);
            if (a8.length > 1 && (a18 = a6.final((Vector)(a17 = (Object)a6.final(a16 = a6.final(a32, a34, a35, a33), a15 = a6.final(a16, a8, a6.try, a6.else), a36, a34, a31, a35, a37)), a12)) != 0) {
                a19 = a18 - 1;
                a20 = a8[a19];
                a22 = a17.get(a18);
            }
            if (a8.length < a6.goto) {
                double a38 = 1.0 - a31 + a37;
                a17 = a8;
                double a39 = a12;
                Optional<AbstractMap.SimpleImmutableEntry> a40 = IntStream.of(a25).parallel().mapToObj(arg_0 -> a6.final((int[])a17, a25, a34, a32, a33, a35, a38, a36, a26, arg_0)).filter(a3 -> {
                    double a4 = (Double)a3.getValue();
                    return DoubleUtils.compare(a4, a39, 1.0E-8) < 0;
                }).max((a2, a3) -> ((Double)a2.getValue()).compareTo((Double)a3.getValue()));
                if (a40.isPresent()) {
                    a21 = (Integer)a40.get().getKey();
                    a23 = (Double)a40.get().getValue();
                }
            }
            if (a20 == 0 && a21 == 0) break;
            if (a20 == 0 || a21 != 0 && a23 > a22) {
                a12 = a23;
                a11 = a6.final(a12, a34, a32, a36, a31, a35, a33, a37, a8, a11);
                a14 = new TurningPoint(a12, a6.this.innerProduct(a11), a11);
                a7.add(a14);
                a13 = MarkowitzCriticalLineUtils.getAddedInvTruncMat(a13, a8, a21, (Matrix)a6.enum);
                a8 = a6.char(a8, a21);
                a9.set(a21, true);
                continue;
            }
            a12 = a22;
            a11 = a6.final(a12, a34, a32, a36, a31, a35, a33, a37, a8, a11);
            a14 = new TurningPoint(a12, a6.this.innerProduct(a11), a11);
            a7.add(a14);
            a13 = MarkowitzCriticalLineUtils.getDeletedInvTruncMat(a13, a8, a19);
            a8 = a6.final(a8, a19);
            a9.set(a20, false);
        }
        if (a5 == a6.void) {
            throw new RuntimeException("exceeds maximal number of iteration!");
        }
        if (a7.isEmpty()) {
            throw new RuntimeException("no turning points computed");
        }
        return a7;
    }

    public MCLNiedermayer(Vector gain, Matrix covariance) {
        this(gain, covariance, new DenseVector(gain.size(), 0.0), new DenseVector(gain.size(), 1.01));
    }

    private Vector final(Vector a2, int[] a3) {
        Vector a4 = VectorFactory.subVector(a2, a3);
        return a4;
    }

    private int[] final(BitSet a2) {
        MCLNiedermayer a4;
        int[] a5 = IntStream.rangeClosed(1, a4.goto).filter(a3 -> !a2.get(a3)).toArray();
        return a5;
    }

    private Vector final(Vector a2, Vector a3, Vector a4, Vector a5, double a6, double a7, double a8) {
        double a9 = 1.0 - a6 + a8;
        double a10 = -a7;
        Vector a11 = a5;
        Vector a12 = a3.add(a4);
        return a11.scaled(a9).add(a12.scaled(a10)).divide(a2);
    }

    private int[] final(int[] a2, int a3) {
        int[] a4 = new int[a2.length - 1];
        System.arraycopy(a2, 0, a4, 0, a3);
        System.arraycopy(a2, a3 + 1, a4, a3, a2.length - a3 - 1);
        return a4;
    }

    private InitialWeight final() throws Exception {
        MCLNiedermayer a2;
        ArrayIndexComparator a3 = new ArrayIndexComparator(a2.this);
        Integer[] a4 = a3.createIndexArray();
        Arrays.sort(a4, a3);
        DenseVector a5 = new DenseVector(a2.goto);
        DenseVector a6 = new DenseVector(a2.goto);
        DenseVector a7 = new DenseVector(a2.goto);
        for (int a8 = 0; a8 < a2.goto; ++a8) {
            a5.set(a8 + 1, a2.try.get(a4[a8]));
            a6.set(a8 + 1, a2.else.get(a4[a8]));
        }
        InitialWeight a9 = a2.final((Vector)a5, a6);
        for (int a10 = 0; a10 < a2.goto; ++a10) {
            a7.set((int)a4[a10], a9.if.get(a10 + 1));
        }
        return new InitialWeight(a7, a4[a9.new - 1]);
    }

    private Matrix final(ImmutableMatrix a2, int[] a3, int[] a4) {
        SubMatrixRef a5 = new SubMatrixRef(a2, a3, a4);
        return a5;
    }

    public void setCachingCriticalLine(boolean toCache) {
        this.new = toCache;
    }

    @Override
    public Vector getOptimalWeightForSetLambda(double lambda) throws Exception {
        List<TurningPoint> a2 = this.new ? this.getTurningPoints() : this.final((TurningPoint a3) -> a3.lambda() <= lambda);
        int a4 = a2.size();
        if (lambda >= a2.get(0).lambda()) {
            return a2.get(0).weight();
        }
        if (lambda <= a2.get(a4 - 1).lambda()) {
            return a2.get(a4 - 1).weight();
        }
        for (int a5 = 0; a5 < a4 - 1; ++a5) {
            TurningPoint a6 = a2.get(a5);
            TurningPoint a7 = a2.get(a5 + 1);
            if (!(lambda <= a6.lambda()) || !(lambda >= a7.lambda())) continue;
            double a8 = MarkowitzCriticalLineUtils.getProportion(lambda, a6.lambda(), a7.lambda());
            return a6.weight().scaled(a8).add(a7.weight().scaled(1.0 - a8));
        }
        throw new Exception("impossible lambda: " + lambda);
    }

    @Override
    public List<TurningPoint> getTurningPoints() throws Exception {
        if (!this.float) {
            this.false.addAll(this.final((TurningPoint a2) -> false));
            this.float = true;
        }
        return Collections.unmodifiableList(this.false);
    }

    private double final(double a2, double a3, Vector a4, double a5, Vector a6, Vector a7, Vector a8, double a9) {
        double a10 = a3;
        double a11 = a8.innerProduct(a4) - a7.innerProduct(a6);
        double a12 = a5;
        double a13 = (a2 * a10 + a11 * a12) / a9;
        return a13;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class InitialWeight {
        private final Vector if;
        private final Integer new;

        private InitialWeight(Vector a2, Integer a3) {
            InitialWeight a4;
            a4.if = a2;
            a4.new = a3;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ArrayIndexComparator
    implements Comparator<Integer> {
        private final ImmutableVector new;

        @Override
        public int compare(Integer index1, Integer index2) {
            return -Double.compare(this.new.get(index1), this.new.get(index2));
        }

        public Integer[] createIndexArray() {
            Integer[] a2 = new Integer[this.new.size()];
            for (int a3 = 0; a3 < this.new.size(); ++a3) {
                a2[a3] = a3 + 1;
            }
            return a2;
        }

        public ArrayIndexComparator(ImmutableVector weight) {
            this.new = weight;
        }
    }
}

