/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.cointegration.check;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.Constants;
import dev.nm.stat.descriptive.correlation.CorrelationMatrix;
import dev.nm.stat.descriptive.covariance.SampleCovariance;
import tech.nmfin.meanreversion.cointegration.NoPairFoundException;
import tech.nmfin.meanreversion.cointegration.PairingModelUtils;
import tech.nmfin.meanreversion.cointegration.check.PairingCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CorrelationCheck
implements PairingCheck {
    private final double false;
    private final Matrix void;
    private final double if;
    private final double new;

    public CorrelationCheck(Matrix A2, double tail, double lowerBound, double upperBound) {
        this.void = A2;
        this.false = tail;
        this.new = lowerBound;
        this.if = upperBound;
    }

    public static double cor(Matrix A2, double tailed) {
        Matrix a2 = PairingModelUtils.getTailedMatrix(A2, tailed);
        SampleCovariance a3 = new SampleCovariance(a2);
        Vector a4 = VectorFactory.diagonal(a3);
        double a5 = 0.0;
        if (a4.norm() > Constants.EPSILON) {
            CorrelationMatrix a6 = new CorrelationMatrix((Matrix)a3);
            a5 = a6.get(1, 2);
        }
        return a5;
    }

    public CorrelationCheck(Matrix A2, double lowerBound, double upperBound) {
        this(A2, 1.0, lowerBound, upperBound);
    }

    @Override
    public boolean isOK() throws NoPairFoundException {
        double a2 = CorrelationCheck.cor(this.void, this.false);
        if (a2 < this.new) {
            throw new NoPairFoundException("cor too small");
        }
        if (a2 > this.if) {
            throw new NoPairFoundException("cor too big");
        }
        return true;
    }
}

